/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchantment;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.enchantment.EnchantBase;
import com.lothrazar.cyclicmagic.registry.GuideRegistry;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantBeheading
extends EnchantBase
implements IHasConfig {
    private Map<String, String> mapClassToSkin;
    private Map<String, NBTTagCompound> mapClassToTag;
    private int percentDrop;

    public EnchantBeheading() {
        super("beheading", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        GuideRegistry.register(this, new ArrayList<String>());
        this.buildDefaultHeadList();
    }

    private void buildDefaultHeadList() {
        this.mapClassToSkin = new HashMap<String, String>();
        this.mapClassToTag = new HashMap<String, NBTTagCompound>();
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityBlaze", "MHF_Blaze");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityCaveSpider", "MHF_CaveSpider");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityChicken", "MHF_Chicken");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityCow", "MHF_Cow");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityEnderman", "MHF_Enderman");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityGhast", "MHF_Ghast");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityIronGolem", "MHF_Golem");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityMagmaCube", "MHF_LavaSlime");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityMooshroom", "MHF_MushroomCow");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityOcelot", "MHF_Ocelot");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityPig", "MHF_Pig");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityPigZombie", "MHF_PigZombie");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntitySheep", "MHF_Sheep");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntitySlime", "MHF_Slime");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntitySpider", "MHF_Spider");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntitySquid", "MHF_Squid");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityVillager", "MHF_Villager");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityWitherSkeleton", "MHF_WSkeleton");
        this.mapClassToSkin.put("net.minecraft.entity.boss.EntityWither", "MHF_Wither");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityWitch", "MHF_Witch");
        this.mapClassToSkin.put("net.minecraft.entity.passive.EntityWolf", "MHF_Wolf");
        this.mapClassToSkin.put("net.minecraft.entity.boss.EntityGuardian", "MHF_Guardian");
        this.mapClassToSkin.put("net.minecraft.entity.boss.EntityElderGuardian", "MHF_Guardian");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntitySnowman", "MHF_SnowGolem");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntitySilverfish", "MHF_Silverfish");
        this.mapClassToSkin.put("net.minecraft.entity.monster.EntityEndermite", "MHF_Endermite");
        this.mapClassToTag.put("net.minecraft.entity.monster.EntityZombieVillager", UtilNBT.buildCustomSkullTag("Zombie Villager Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2ZmMDQ4MmZkMzJmYWIyY2U5ZjVmYTJlMmQ5YjRkYzc1NjFkYTQyMjE1MmM5OWZjODA0YjkxMzljYWYyNTZiIn19fQ=="));
        this.mapClassToTag.put("net.minecraft.entity.monster.EntityVindicator", UtilNBT.buildCustomSkullTag("Vindicator Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTAwZDNmZmYxNmMyZGNhNTliOWM1OGYwOTY1MjVjODY5NzExNjZkYmFlMTMzYjFiMDUwZTVlZTcxNjQ0MyJ9fX0="));
        this.mapClassToTag.put("net.minecraft.entity.monster.EntityEvoker", UtilNBT.buildCustomSkullTag("Evoker Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTAwZDNmZmYxNmMyZGNhNTliOWM1OGYwOTY1MjVjODY5NzExNjZkYmFlMTMzYjFiMDUwZTVlZTcxNjQ0MyJ9fX0="));
        this.mapClassToTag.put("net.minecraft.entity.monster.EntityShulker", UtilNBT.buildCustomSkullTag("Shulker Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDhmYjk2YmY0YTlhMzFiMjU1MzhiNzEyMTdkYThiNjM0ZThjMDVkNGMzNWE2YWI4N2FjYjM3ZjkzYTZmMmMifX19"));
        this.mapClassToTag.put("net.minecraft.entity.passive.EntityRabbit", UtilNBT.buildCustomSkullTag("Rabbit Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGM3YTMxN2VjNWMxZWQ3Nzg4Zjg5ZTdmMWE2YWYzZDJlZWI5MmQxZTk4NzljMDUzNDNjNTdmOWQ4NjNkZTEzMCJ9fX0="));
        this.mapClassToTag.put("net.minecraft.entity.monster.EntityPolarBear", UtilNBT.buildCustomSkullTag("Polar Bear Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDQ2ZDIzZjA0ODQ2MzY5ZmEyYTM3MDJjMTBmNzU5MTAxYWY3YmZlODQxOTk2NjQyOTUzM2NkODFhMTFkMmIifX19"));
        this.mapClassToTag.put("net.minecraft.entity.passive.EntityLlama", UtilNBT.buildCustomSkullTag("Llama Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNmMWIzYjNmNTM5ZDJmNjNjMTcyZTk0Y2FjZmFhMzkxZThiMzg1Y2RkNjMzZjNiOTkxYzc0ZTQ0YjI4In19fQ=="));
        this.mapClassToTag.put("net.minecraft.entity.passive.EntityBat", UtilNBT.buildCustomSkullTag("Bat Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzJiMWVjZmY3N2ZmZTNiNTAzYzMwYTU0OGViMjNhMWEwOGZhMjZmZDY3Y2RmZjM4OTg1NWQ3NDkyMTM2OCJ9fX0="));
        NBTTagCompound horseTag = UtilNBT.buildCustomSkullTag("Horse Head", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjE5MDI4OTgzMDg3MzBjNDc0NzI5OWNiNWE1ZGE5YzI1ODM4YjFkMDU5ZmU0NmZjMzY4OTZmZWU2NjI3MjkifX19");
        this.mapClassToTag.put("net.minecraft.entity.passive.AbstractHorse", horseTag);
        this.mapClassToTag.put("net.minecraft.entity.passive.EntityHorse", horseTag);
        this.mapClassToTag.put("net.minecraft.entity.passive.EntitySkeletonHorse", horseTag);
        this.mapClassToTag.put("net.minecraft.entity.passive.EntityZombieHorse", horseTag);
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (event.getSource().func_76364_f() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase) {
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76364_f();
            EntityLivingBase target = (EntityLivingBase)event.getEntity();
            int level = this.getCurrentLevelTool((EntityLivingBase)attacker);
            if (level < 0) {
                return;
            }
            World world = attacker.field_70170_p;
            if (MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)100) > this.percentDrop) {
                return;
            }
            BlockPos pos = target.func_180425_c();
            String key = target.getClass().getName();
            if (this.mapClassToSkin.containsKey(key)) {
                UtilItemStack.dropItemStackInWorld(world, pos, UtilNBT.buildNamedPlayerSkull(this.mapClassToSkin.get(key)));
            } else if (this.mapClassToTag.containsKey(key)) {
                UtilItemStack.dropItemStackInWorld(world, pos, UtilNBT.buildSkullFromTag(this.mapClassToTag.get(key)));
            } else if (target instanceof EntityCreeper) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151144_bL, 1, 4));
            } else if (target instanceof EntityZombie) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151144_bL, 1, 2));
            } else if (target instanceof EntitySkeleton) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151144_bL, 1, 0));
            } else if (target instanceof EntityWitherSkeleton) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151144_bL, 1, 1));
            } else if (target instanceof EntityDragon) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151144_bL, 1, 5));
            } else if (target instanceof EntityPlayer) {
                UtilItemStack.dropItemStackInWorld(world, pos, UtilNBT.buildNamedPlayerSkull((EntityPlayer)target));
            } else {
                ModCyclic.logger.info("beheading mob not found " + target.getClass().getName());
                ModCyclic.logger.info("beheading mob not found " + target.getClass().getName());
                ModCyclic.logger.info("beheading mob not found " + target.getClass().getName());
                ModCyclic.logger.info("beheading mob not found " + target.getClass().getName());
                ModCyclic.logger.info("beheading mob not found " + target.getClass().getName());
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String[] mappings;
        this.percentDrop = config.getInt("BeheadingPercent", "modpacks", 10, 1, 100, "Percent chance that the beheading enchant will actually drop a head.");
        String[] defaultConf = new String[]{"net.minecraft.entity.monster.EntityVex-Vazkii", "elucent.roots.entity.EntitySprite-Darkosto"};
        for (String s : mappings = config.getStringList("BeheadingExtraMobs", "modpacks", defaultConf, "By default Beheading works on vanilla mobs and player heads.  Add creatures from any other mod here along with a player name to act as the skin for the dropped head.  Format is: classpath-player")) {
            String[] spl;
            if (!s.contains("-") || (spl = s.split("-")).length != 2) continue;
            this.mapClassToSkin.put(spl[0], spl[1]);
        }
    }
}

