/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.base;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.Const;
import com.lothrazar.cyclicmagic.gui.ITooltipButton;
import com.lothrazar.cyclicmagic.gui.ProgressBar;
import com.lothrazar.cyclicmagic.gui.button.GuiButtonTogglePreview;
import com.lothrazar.cyclicmagic.gui.button.GuiButtonToggleRedstone;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class GuiBaseContainer
extends GuiContainer {
    public static final int FONTCOLOR = 0x404040;
    public TileEntityBaseMachineInvo tile;
    protected Const.ScreenSize screenSize = Const.ScreenSize.STANDARD;
    protected int fieldRedstoneBtn = -1;
    protected int fieldPreviewBtn = -1;
    protected int fieldFuel = -1;
    protected int fieldMaxFuel = -1;
    public ProgressBar progressBar = null;
    private GuiButtonToggleRedstone redstoneBtn = null;
    private GuiButtonTogglePreview btnPreview;

    public GuiBaseContainer(Container inventorySlotsIn, TileEntityBaseMachineInvo tile) {
        super(inventorySlotsIn);
        this.tile = tile;
    }

    public GuiBaseContainer(Container inventorySlotsIn) {
        super(inventorySlotsIn);
        this.tile = null;
    }

    protected void setScreenSize(Const.ScreenSize ss) {
        this.screenSize = ss;
        this.field_146999_f = this.screenSize.width();
        this.field_147000_g = this.screenSize.height();
    }

    protected void setFieldFuel(int ordinal) {
        this.fieldFuel = ordinal;
        this.fieldMaxFuel = ordinal + 1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + 4;
        int y = this.field_147009_r + 4;
        if (this.fieldRedstoneBtn >= 0) {
            this.redstoneBtn = new GuiButtonToggleRedstone(1, x, y, this.tile.func_174877_v());
            this.field_146292_n.add(this.redstoneBtn);
            y += 4 + this.redstoneBtn.field_146120_f;
        }
        if (this.fieldPreviewBtn > 0) {
            this.btnPreview = new GuiButtonTogglePreview(2, x, y, this.tile.func_174877_v());
            this.field_146292_n.add(this.btnPreview);
        }
    }

    protected void drawFieldAt(int x, int y, int f) {
        String display = "" + this.tile.func_174887_a_(f);
        x = display.length() > 1 ? x - 3 : x;
        this.drawString(display, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawNameText();
        this.drawFuelText();
        this.updateToggleButtonStates();
    }

    public void drawNameText() {
        if (this.tile != null) {
            String s = UtilChat.lang(this.tile.func_70005_c_());
            this.drawString(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6);
        }
    }

    public void updateToggleButtonStates() {
        if (this.redstoneBtn != null) {
            this.redstoneBtn.setState(this.tile.func_174887_a_(this.fieldRedstoneBtn));
        }
        if (this.btnPreview != null) {
            if (this.tile.func_174887_a_(this.fieldPreviewBtn) == 1) {
                this.btnPreview.setStateOn();
            } else {
                this.btnPreview.setStateOff();
            }
        }
    }

    public void drawString(String s, int x, int y) {
        this.field_146289_q.func_78276_b(UtilChat.lang(s), x, y, 0x404040);
    }

    public int getMiddleY() {
        int yMiddle = (this.field_146295_m - this.field_147000_g) / 2;
        return yMiddle;
    }

    public int getMiddleX() {
        int xMiddle = (this.field_146294_l - this.field_146999_f) / 2;
        return xMiddle;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.screenSize.texture());
        int thisX = this.getMiddleX();
        int thisY = this.getMiddleY();
        boolean u = false;
        boolean v = false;
        Gui.func_146110_a((int)thisX, (int)thisY, (float)((float)u), (float)((float)v), (int)this.screenSize.width(), (int)this.screenSize.height(), (float)this.screenSize.width(), (float)this.screenSize.height());
        if (this.progressBar != null) {
            this.drawProgressBar();
        }
        if (this.fieldFuel > -1 && this.tile.getFuelCurrent() > 0) {
            this.drawFuelBar();
        }
    }

    public void drawFuelText() {
        double pct;
        if (this.fieldFuel > -1 && (pct = this.tile.getPercentFormatted()) > 0.0) {
            GL11.glPushMatrix();
            float fontScale = 0.5f;
            GL11.glScalef((float)fontScale, (float)fontScale, (float)fontScale);
            this.drawString(pct + "", this.field_146999_f * 2 + 20, 24);
            GL11.glPopMatrix();
        }
    }

    public void drawFuelBar() {
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.FUEL_CTR);
        Gui.func_146110_a((int)(this.field_147003_i + this.screenSize.width() + 1), (int)this.field_147009_r, (float)((float)u), (float)((float)v), (int)28, (int)100, (float)28.0f, (float)100.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.FUEL_INNER);
        float percent = (float)this.tile.func_174887_a_(this.fieldFuel) / (float)this.tile.func_174887_a_(this.fieldMaxFuel);
        Gui.func_146110_a((int)(this.field_147003_i + this.screenSize.width() + 8), (int)(this.field_147009_r + 8), (float)((float)u), (float)((float)v), (int)14, (int)((int)(84.0f * percent)), (float)14.0f, (float)84.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            if (!((GuiButton)this.field_146292_n.get(i)).func_146115_a() || !(this.field_146292_n.get(i) instanceof ITooltipButton)) continue;
            ITooltipButton btn = (ITooltipButton)this.field_146292_n.get(i);
            if (btn.getTooltips() == null) break;
            this.drawHoveringText(btn.getTooltips(), mouseX, mouseY, this.field_146289_q);
            break;
        }
    }

    public void drawProgressBar() {
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(this.progressBar.getProgressCtrAsset());
        Gui.func_146110_a((int)(this.field_147003_i + this.progressBar.xOffset), (int)(this.field_147009_r + this.progressBar.yOffset), (float)((float)u), (float)((float)v), (int)156, (int)7, (float)156.0f, (float)7.0f);
        if (this.progressBar.getProgressCurrent() > 0) {
            this.field_146297_k.func_110434_K().func_110577_a(this.progressBar.getProgressAsset());
            float percent = (float)this.progressBar.getProgressCurrent() / (float)this.progressBar.maxValue;
            Gui.func_146110_a((int)(this.field_147003_i + this.progressBar.xOffset), (int)(this.field_147009_r + this.progressBar.yOffset), (float)((float)u), (float)((float)v), (int)((int)(156.0f * percent)), (int)7, (float)156.0f, (float)7.0f);
        }
    }
}

