/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerFlying;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChorusGlowing
extends ItemFood
implements IHasRecipe {
    private static final String KEY_BOOLEAN = "cyclicflying_on";
    private static final String KEY_TIMER = "cyclicflying_timer";
    private static final String KEY_POTION = "cyclicflying_potion";
    public static final int FLY_SECONDS = 10;
    public static final int POTION_SECONDS = 10;

    public ItemChorusGlowing() {
        super(4, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        this.setFlying(player);
        if (!world.field_72995_K) {
            UtilNBT.incrementPlayerIntegerNBT(player, KEY_TIMER, 200);
            player.getEntityData().func_74757_a(KEY_BOOLEAN, true);
            UtilNBT.incrementPlayerIntegerNBT(player, KEY_POTION, 10);
        }
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this, 3), "lal", "lal", "lal", Character.valueOf('l'), "dustGlowstone", Character.valueOf('a'), Items.field_185161_cS);
    }

    private void setFlying(EntityPlayer player) {
        player.field_70143_R = 0.0f;
        player.field_71075_bZ.field_75101_c = true;
        player.field_71075_bZ.field_75100_b = true;
    }

    private void setNonFlying(EntityPlayer player) {
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        if (player instanceof EntityPlayerMP) {
            ModCyclic.network.sendTo((IMessage)new PacketSyncPlayerFlying(false), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.getEntityData().func_74767_n(KEY_BOOLEAN)) {
            int playerGhost = player.getEntityData().func_74762_e(KEY_TIMER);
            if (playerGhost > 0) {
                if (playerGhost % 20 == 0) {
                    int secs = playerGhost / 20;
                    UtilChat.addChatMessage(player, "" + secs);
                }
                UtilNBT.incrementPlayerIntegerNBT(player, KEY_TIMER, -1);
                this.setFlying(player);
            } else {
                player.getEntityData().func_74757_a(KEY_BOOLEAN, false);
                int playerPot = player.getEntityData().func_74762_e(KEY_POTION);
                player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 20 * playerPot));
                player.getEntityData().func_74768_a(KEY_POTION, 0);
                this.setNonFlying(player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltips, boolean advanced) {
        tooltips.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

