/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.IHasClickToggle;
import com.lothrazar.cyclicmagic.item.base.BaseTool;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderWing
extends BaseTool
implements IHasRecipe,
IHasClickToggle {
    private static final int cooldown = 600;
    private static final int durability = 16;
    private WarpType warpType;

    public ItemEnderWing(WarpType type) {
        super(16);
        this.warpType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    public void toggle(EntityPlayer player, ItemStack held) {
        this.tryActivate(player, held);
    }

    private boolean tryActivate(EntityPlayer player, ItemStack held) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        World world = player.func_130014_f_();
        if (player.field_71093_bK != 0) {
            UtilChat.addChatMessage(player, "command.worldhome.dim");
            return false;
        }
        boolean success = false;
        switch (this.warpType) {
            case BED: {
                success = UtilWorld.tryTpPlayerToBed(world, player);
                break;
            }
            case SPAWN: {
                UtilEntity.teleportWallSafe((EntityLivingBase)player, world, world.func_175694_M());
                success = true;
                break;
            }
        }
        if (success) {
            UtilItemStack.damageItem(player, held);
            player.func_184811_cZ().func_185145_a((Item)this, 600);
        }
        return success;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.tryActivate(player, stack)) {
            super.onUse(stack, player, world, hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        switch (this.warpType) {
            case BED: {
                tooltip.add(UtilChat.lang("item.tool_warp_home.tooltip"));
                break;
            }
            case SPAWN: {
                tooltip.add(UtilChat.lang("item.tool_warp_spawn.tooltip"));
                break;
            }
        }
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.warpType) {
            case BED: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " ft", "ggf", "dg ", Character.valueOf('t'), new ItemStack(Items.field_151073_bk), Character.valueOf('f'), "feather", Character.valueOf('g'), "ingotGold", Character.valueOf('d'), new ItemStack(Items.field_151061_bv));
            }
            case SPAWN: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " ff", "ggf", "dg ", Character.valueOf('f'), "feather", Character.valueOf('g'), "nuggetGold", Character.valueOf('d'), "gemDiamond");
            }
        }
        return null;
    }

    @Override
    public boolean isOn(ItemStack held) {
        return true;
    }

    public static enum WarpType {
        BED,
        SPAWN;

    }
}

