/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.base.BaseTool;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemFangs
extends BaseTool
implements IHasRecipe {
    private static final int COOLDOWN = 10;
    private static final int DURABILITY = 666;
    private static final int MAX_RANGE = 16;

    public ItemFangs() {
        super(666);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        this.summonFangRay(player, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        UtilItemStack.damageItem(player, player.func_184586_b(hand));
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return EnumActionResult.PASS;
        }
        this.summonFangRay(player, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY + 1.0f, (float)pos.func_177952_p() + hitZ);
        UtilItemStack.damageItem(player, player.func_184586_b(hand));
        return EnumActionResult.SUCCESS;
    }

    private void summonFangRay(EntityPlayer caster, double posX, double posY, double posZ) {
        double minY = Math.min(posY, caster.field_70163_u);
        float arctan = (float)MathHelper.func_181159_b((double)(posZ - caster.field_70161_v), (double)(posX - caster.field_70165_t));
        for (int i = 0; i < 16; ++i) {
            double fract = 1.25 * (double)(i + 1);
            this.summonFangSingle(caster, caster.field_70165_t + (double)MathHelper.func_76134_b((float)arctan) * fract, minY, caster.field_70161_v + (double)MathHelper.func_76126_a((float)arctan) * fract, arctan, i);
        }
        this.onCastSuccess(caster);
    }

    private void summonFangSingle(EntityPlayer caster, double x, double y, double z, float yaw, int delay) {
        EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(caster.field_70170_p, x, y, z, yaw, delay, (EntityLivingBase)caster);
        caster.field_70170_p.func_72838_d((Entity)entityevokerfangs);
    }

    private void onCastSuccess(EntityPlayer caster) {
        UtilSound.playSound(caster, SoundEvents.field_191247_bq);
        caster.func_184811_cZ().func_185145_a((Item)this, 10);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "wpc", " dp", "r w", Character.valueOf('w'), Blocks.field_150321_G, Character.valueOf('r'), Blocks.field_185764_cQ, Character.valueOf('c'), Items.field_185158_cP, Character.valueOf('p'), Blocks.field_150403_cj, Character.valueOf('d'), "blockEmerald");
    }
}

