/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.base.BaseItem;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHorseUpgrade
extends BaseItem
implements IHasRecipe {
    public static int HEARTS_MAX;
    public static int SPEED_MAX;
    public static int JUMP_MAX;
    private static final double SPEED_AMT = 0.004;
    private static final double JUMP_AMT = 0.008;
    private ItemStack recipeItem;
    private HorseUpgradeType upgradeType;

    public ItemHorseUpgrade(HorseUpgradeType type, ItemStack rec) {
        this.recipeItem = rec;
        this.upgradeType = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        Item carrot = stack.func_77973_b();
        tooltip.add(UtilChat.lang(carrot.func_77667_c(stack) + ".effect"));
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), Items.field_151172_bF, this.recipeItem);
    }

    public static void onHorseInteract(AbstractHorse ahorse, EntityPlayer player, ItemStack held, ItemHorseUpgrade heldItem) {
        if (ahorse.field_70128_L) {
            return;
        }
        if (player.func_184811_cZ().func_185141_a(held.func_77973_b())) {
            return;
        }
        World world = player.func_130014_f_();
        boolean success = false;
        switch (heldItem.upgradeType) {
            case HEALTH: {
                float mh = (float)ahorse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                if (!(mh < (float)(2 * HEARTS_MAX))) break;
                ahorse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(mh + 2.0f));
                success = true;
                break;
            }
            case JUMP: {
                if (ReflectionRegistry.horseJumpStrength != null) {
                    double jump = ahorse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111126_e();
                    double newjump = jump + 0.008;
                    if (!(UtilEntity.getJumpTranslated(newjump) < (double)JUMP_MAX)) break;
                    ahorse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111128_a(newjump);
                    success = true;
                    break;
                }
                ModCyclic.logger.error("Failed to set horse jump strength, reflection failed on JUMP_STRENGTH");
                break;
            }
            case SPEED: {
                double speed = ahorse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                double newSpeed = speed + 0.004;
                if (!(UtilEntity.getSpeedTranslated(newSpeed) < (double)SPEED_MAX)) break;
                ahorse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(newSpeed);
                success = true;
                break;
            }
            case TYPE: {
                EntityZombieHorse toSpawn = null;
                if (ahorse instanceof EntityHorse) {
                    toSpawn = new EntityZombieHorse(world);
                } else if (ahorse instanceof EntityZombieHorse) {
                    toSpawn = new EntitySkeletonHorse(world);
                } else if (ahorse instanceof EntitySkeletonHorse) {
                    toSpawn = new EntityHorse(world);
                }
                if (toSpawn == null) break;
                if (!world.field_72995_K) {
                    toSpawn.func_70107_b(ahorse.field_70165_t, ahorse.field_70163_u, ahorse.field_70161_v);
                    toSpawn.field_98038_p = true;
                    world.func_72838_d((Entity)toSpawn);
                }
                ahorse.func_70097_a(DamageSource.field_76376_m, 5000.0f);
                break;
            }
            case VARIANT: {
                if (!(ahorse instanceof EntityHorse)) break;
                EntityHorse horse = (EntityHorse)ahorse;
                int var = horse.func_110202_bQ();
                int varReduced = 0;
                int varNew = 0;
                while (var - 256 > 0) {
                    varReduced += 256;
                    var -= 256;
                }
                switch (var) {
                    case 4: {
                        varNew = 3;
                        break;
                    }
                    case 3: {
                        varNew = 6;
                        break;
                    }
                    case 6: {
                        varNew = 2;
                        break;
                    }
                    case 2: {
                        varNew = 1;
                        break;
                    }
                    case 1: {
                        varNew = 5;
                        break;
                    }
                    case 5: {
                        varNew = 0;
                        break;
                    }
                    case 0: {
                        varNew = 4;
                    }
                }
                horse.func_110235_q(varNew += varReduced);
                success = true;
            }
        }
        if (success) {
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            player.func_184811_cZ().func_185145_a((Item)heldItem, 5);
            UtilParticle.spawnParticle(ahorse.func_130014_f_(), EnumParticleTypes.SMOKE_LARGE, ahorse.func_180425_c());
            UtilSound.playSound(player, ahorse.func_180425_c(), SoundEvents.field_187711_cp, SoundCategory.NEUTRAL);
            ahorse.func_110227_p(true);
        }
    }

    public static enum HorseUpgradeType {
        HEALTH,
        JUMP,
        SPEED,
        TYPE,
        VARIANT;

    }
}

