/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.base.BaseItem;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPasswordRemote
extends BaseItem
implements IHasRecipe {
    public ItemPasswordRemote() {
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        BlockPos pointer = UtilNBT.getItemStackBlockPos(stack);
        if (pointer != null) {
            tooltip.add(TextFormatting.RED + UtilChat.blockPosToString(pointer));
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLever) {
            UtilNBT.setItemStackBlockPos(stack, pos);
            if (worldIn.field_72995_K) {
                UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".saved");
            }
            UtilSound.playSound(playerIn, SoundEvents.field_187750_dc);
            return EnumActionResult.SUCCESS;
        }
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean trigger(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        BlockPos blockPos = UtilNBT.getItemStackBlockPos(stack);
        if (blockPos == null) {
            if (worldIn.field_72995_K) {
                UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".invalid");
            }
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(blockPos);
        if (blockState == null || blockState.func_177230_c() != Blocks.field_150442_at) {
            if (worldIn.field_72995_K) {
                UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".invalid");
            }
            return false;
        }
        boolean hasPowerHere = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
        this.setLeverPowerState(worldIn, blockPos, blockState, hasPowerHere);
        UtilSound.playSound(playerIn, SoundEvents.field_187750_dc);
        return true;
    }

    private void setLeverPowerState(World worldIn, BlockPos blockPos, IBlockState blockState, boolean hasPowerHere) {
        IBlockState stateNew = blockState.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(!hasPowerHere));
        boolean success = worldIn.func_175656_a(blockPos, stateNew);
        if (success) {
            this.flagUpdate(worldIn, blockPos, blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177977_b(), blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177984_a(), blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177976_e(), blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177974_f(), blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177978_c(), blockState, stateNew);
            this.flagUpdate(worldIn, blockPos.func_177968_d(), blockState, stateNew);
        }
    }

    private void flagUpdate(World worldIn, BlockPos blockPos, IBlockState blockState, IBlockState stateNew) {
        worldIn.func_175685_c(blockPos, blockState.func_177230_c(), true);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.STONE.func_176624_a()), Blocks.field_150430_aB, Blocks.field_150442_at);
    }
}

