/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.base.BaseTool;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilHarvestCrops;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemScythe
extends BaseTool
implements IHasRecipe {
    private static final int RADIUS = 6;
    private static final int RADIUS_SNEAKING = 2;
    private UtilHarvestCrops.HarvestSetting conf;
    private HarvestType harvestType;

    public ItemScythe(HarvestType c) {
        super(1000);
        this.harvestType = c;
        this.conf = new UtilHarvestCrops.HarvestSetting();
        this.conf.dropInPlace = true;
        switch (this.harvestType) {
            case CROPS: {
                this.conf.doesPumpkinBlocks = true;
                this.conf.doesMelonBlocks = true;
                this.conf.doesCrops = true;
                this.conf.doesCactus = true;
                this.conf.doesReeds = true;
                break;
            }
            case WEEDS: {
                this.conf.doesFlowers = true;
                this.conf.doesMushroom = true;
                this.conf.doesTallgrass = true;
                this.conf.doesSapling = true;
                this.conf.doesIShearable = true;
                break;
            }
            case LEAVES: {
                this.conf.doesLeaves = true;
                break;
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos offset = pos;
        if (side != null) {
            offset = pos.func_177972_a(side);
        }
        int r = player.func_70093_af() ? 2 : 6;
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177977_b().func_177977_b(), r, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177977_b(), r, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset, r, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177984_a(), r, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177984_a().func_177984_a(), r, this.conf);
        super.onUse(stack, player, worldObj, hand);
        return super.func_180614_a(player, worldObj, offset, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.harvestType) {
            case CROPS: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "gemQuartz", Character.valueOf('s'), Items.field_151018_J);
            }
            case LEAVES: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), "string", Character.valueOf('s'), Items.field_151049_t);
            }
            case WEEDS: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), "string", Character.valueOf('s'), Items.field_151018_J);
            }
        }
        return null;
    }

    public static enum HarvestType {
        WEEDS,
        LEAVES,
        CROPS;

    }
}

