/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.base.BaseTool;
import com.lothrazar.cyclicmagic.net.PacketSleepClient;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemSleepingMat
extends BaseTool
implements IHasRecipe,
IHasConfig {
    private static int seconds;
    public static boolean doPotions;
    private boolean doesSetSpawn;

    public ItemSleepingMat() {
        super(100);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            EntityPlayer.SleepResult result = this.canPlayerSleep(player, world);
            if (result == EntityPlayer.SleepResult.OK) {
                CapabilityRegistry.IPlayerExtendedProperties sleep = CapabilityRegistry.getPlayerProperties(player);
                if (sleep != null) {
                    sleep.setSleeping(true);
                    if (doPotions) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, seconds * 20, 0));
                        player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, seconds * 20, 0));
                    }
                    this.onUse(stack, player, world, hand);
                    ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)true, (String[])new String[]{"sleeping", "field_71083_bS"});
                    ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"sleepTimer", "field_71076_b"});
                    UtilChat.addChatMessage(player, this.func_77658_a() + ".trying");
                    player.field_71081_bT = player.func_180425_c();
                    ModCyclic.network.sendTo((IMessage)new PacketSleepClient(player.field_71081_bT), mp);
                    player.field_70181_x = 0.0;
                    player.field_70179_y = 0.0;
                    player.field_70159_w = 0.0;
                    world.func_72854_c();
                    SPacketUseBed sleepPacket = new SPacketUseBed(player, player.func_180425_c());
                    mp.func_71121_q().func_73039_n().func_151247_a((Entity)player, (Packet)sleepPacket);
                    mp.field_71135_a.func_147359_a((Packet)sleepPacket);
                    ItemSleepingMat.setRenderOffsetForSleep(player, player.func_174811_aO());
                    if (this.doesSetSpawn) {
                        System.out.println("settingspawn");
                        player.func_180473_a(player.func_180425_c(), true);
                    }
                } else {
                    UtilChat.addChatMessage(player, "tile.bed.noSleep");
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            UtilChat.addChatMessage(player, "tile.bed.noSleep");
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public static void setRenderOffsetForSleep(EntityPlayer mp, EnumFacing p_175139_1_) {
        mp.field_71079_bU = -1.8f * (float)p_175139_1_.func_82601_c();
        mp.field_71089_bV = -1.8f * (float)p_175139_1_.func_82599_e();
    }

    private EntityPlayer.SleepResult canPlayerSleep(EntityPlayer player, World world) {
        if (!player.func_70089_S()) {
            return EntityPlayer.SleepResult.OTHER_PROBLEM;
        }
        if (world.func_72935_r()) {
            return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
        }
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, player.func_180425_c());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResultStatus() != null) {
            return event.getResultStatus();
        }
        return EntityPlayer.SleepResult.OK;
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent evt) {
        EntityPlayer p = evt.getEntityPlayer();
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)p.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            p.field_71081_bT = p.func_180425_c();
            evt.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void handleSleepInBed(PlayerSleepInBedEvent event) {
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)event.getEntityPlayer().getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            event.setResult(EntityPlayer.SleepResult.OK);
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent evt) {
        EntityPlayer p = evt.getEntityPlayer();
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)p.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            sleep.setSleeping(false);
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        doPotions = config.getBoolean("SleepingMatPotions", "cyclicmagic.items", true, "False will disable the potion effects given by the Sleeping Mat");
        seconds = config.getInt("SleepingMatPotion", "modpacks", 20, 0, 600, "Seconds of potion effect caused by using the sleeping mat");
        this.doesSetSpawn = config.getBoolean("SleepingMatSetsSpawn", "cyclicmagic.items", false, "True means using this at night will set your spawn point, just like a bed.");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack(Blocks.field_150325_L, 1, EnumDyeColor.RED.func_176765_a()), "leather");
    }
}

