/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.base.BaseTool;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class ItemSpawnInspect
extends BaseTool
implements IHasRecipe {
    private static final int DURABILITY = 2000;
    private static final int COOLDOWN = 10;

    public ItemSpawnInspect() {
        super(2000);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldObj, BlockPos posIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (side == null || posIn == null || side != EnumFacing.UP) {
            if (!worldObj.field_72995_K) {
                UtilChat.addChatMessage(player, "item.tool_spawn_inspect.up");
            }
            return super.func_180614_a(player, worldObj, posIn, hand, side, hitX, hitY, hitZ);
        }
        boolean showOdds = player.func_70093_af();
        if (!worldObj.field_72995_K) {
            ChunkProviderServer s = (ChunkProviderServer)worldObj.func_72863_F();
            BlockPos pos = posIn.func_177972_a(side);
            Chunk chunk = worldObj.func_175726_f(pos);
            if (worldObj.func_72863_F() instanceof ChunkProviderServer) {
                ArrayList<SpawnDetail> names = new ArrayList<SpawnDetail>();
                for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                    List list = s.func_177458_a(creatureType, pos);
                    for (Biome.SpawnListEntry entry : list) {
                        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)entry.field_76300_b), (World)worldObj, (BlockPos)pos)) continue;
                        names.add(new SpawnDetail(entry, creatureType));
                        if (!entry.field_76300_b.equals(EntitySkeleton.class) || player.field_71093_bK != -1) continue;
                        names.add(new SpawnDetail("WitherSkeleton", creatureType, entry.field_76292_a));
                    }
                }
                if (names.size() > 0) {
                    String strLight = "Light: " + chunk.func_177443_a(pos, 0) + " (" + chunk.func_177413_a(EnumSkyBlock.SKY, pos) + " sky, " + chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) + " block)";
                    UtilChat.addChatMessage(player, strLight);
                    Collections.sort(names, new Comparator<SpawnDetail>(){

                        @Override
                        public int compare(SpawnDetail o1, SpawnDetail o2) {
                            return o1.getSortBy().compareTo(o2.getSortBy());
                        }
                    });
                    ArrayList<String> csv = new ArrayList<String>();
                    for (SpawnDetail detail : names) {
                        csv.add(detail.toString(showOdds));
                    }
                    UtilChat.addChatMessage(player, String.join((CharSequence)", ", csv));
                } else {
                    UtilChat.addChatMessage(player, "item.tool_spawn_inspect.empty");
                }
            }
        }
        player.func_184811_cZ().func_185145_a((Item)this, 10);
        super.onUse(stack, player, worldObj, hand);
        return super.func_180614_a(player, worldObj, posIn, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " sg", " bs", "b  ", Character.valueOf('b'), new ItemStack(Items.field_151072_bj), Character.valueOf('s'), new ItemStack(Items.field_151145_ak), Character.valueOf('g'), "blockGlassPurple");
    }

    public static class SpawnDetail {
        private int itemWeight;
        private String displayName;
        private String creatureTypeName;

        public SpawnDetail(Biome.SpawnListEntry entry, EnumCreatureType creatureType) {
            this.itemWeight = entry.field_76292_a;
            this.creatureTypeName = creatureType.name();
            this.displayName = entry.field_76300_b.getSimpleName().replace("Entity", "");
        }

        public SpawnDetail(String n, EnumCreatureType creatureType, int odds) {
            this.itemWeight = odds;
            this.displayName = n;
            this.creatureTypeName = creatureType.name();
        }

        public String getSortBy() {
            return this.displayName;
        }

        public String toString(boolean showOdds) {
            if (showOdds) {
                return "[" + this.creatureTypeName + ", " + String.format("%03d", this.itemWeight) + "] " + this.displayName;
            }
            return this.displayName;
        }
    }
}

