/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.projectile;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDungeonEye;
import com.lothrazar.cyclicmagic.entity.projectile.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.item.projectile.BaseItemProjectile;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProjectileDungeon
extends BaseItemProjectile
implements IHasRecipe,
IHasConfig {
    private static int DUNGEONRADIUS = 64;

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, double x, double y, double z) {
        return new EntityDungeonEye(world, x, y, z);
    }

    @Override
    public void syncConfig(Configuration config) {
        DUNGEONRADIUS = config.getInt("Ender Dungeon Radius", "cyclicmagic.items", 128, 8, 128, "Search radius of dungeonfinder");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this, 8), "enderpearl", new ItemStack(Blocks.field_150341_Y), "cropNetherWart");
    }

    @Override
    void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockpos = UtilWorld.findClosestBlock(player, Blocks.field_150474_ac, DUNGEONRADIUS);
        if (blockpos != null) {
            EntityDungeonEye entityendereye = new EntityDungeonEye(world, (EntityLivingBase)player);
            this.doThrow(world, player, hand, entityendereye, 0.5f);
            entityendereye.moveTowards(blockpos);
        } else {
            UtilSound.playSound(player, player.func_180425_c(), SoundEvents.field_187646_bt);
            if (world.field_72995_K) {
                UtilChat.addChatMessage(player, UtilChat.lang("item.ender_dungeon.notfound") + " " + DUNGEONRADIUS);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

