/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.item.gear.ItemPowerArmor;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.registry.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.MaterialRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GearPurpleModule
extends BaseEventModule
implements IHasConfig {
    private static final String MATERIALNAME = "power";
    private boolean enableWaterGear;

    @Override
    public void onPreInit() {
        this.registerMaterial();
        if (this.enableWaterGear) {
            ItemPowerArmor purple_boots = new ItemPowerArmor(MaterialRegistry.powerArmorMaterial, EntityEquipmentSlot.FEET);
            ItemRegistry.register((Item)purple_boots, "purple_boots", GuideRegistry.GuideCategory.GEAR);
            ItemPowerArmor purple_leggings = new ItemPowerArmor(MaterialRegistry.powerArmorMaterial, EntityEquipmentSlot.LEGS);
            ItemRegistry.register((Item)purple_leggings, "purple_leggings", GuideRegistry.GuideCategory.GEAR);
            ItemPowerArmor purple_chestplate = new ItemPowerArmor(MaterialRegistry.powerArmorMaterial, EntityEquipmentSlot.CHEST);
            ItemRegistry.register((Item)purple_chestplate, "purple_chestplate", GuideRegistry.GuideCategory.GEAR);
            ItemPowerArmor purple_helmet = new ItemPowerArmor(MaterialRegistry.powerArmorMaterial, EntityEquipmentSlot.HEAD);
            ItemRegistry.register((Item)purple_helmet, "purple_helmet", GuideRegistry.GuideCategory.GEAR);
        }
    }

    private void registerMaterial() {
        ItemArmor.ArmorMaterial mimicArmor = ItemArmor.ArmorMaterial.IRON;
        MaterialRegistry.powerArmorMaterial = EnumHelper.addArmorMaterial((String)MATERIALNAME, (String)"cyclicmagic:power", (int)15, (int[])new int[]{mimicArmor.func_78044_b(EntityEquipmentSlot.FEET), mimicArmor.func_78044_b(EntityEquipmentSlot.LEGS), mimicArmor.func_78044_b(EntityEquipmentSlot.CHEST), mimicArmor.func_78044_b(EntityEquipmentSlot.HEAD)}, (int)mimicArmor.func_78045_a(), (SoundEvent)mimicArmor.func_185017_b(), (float)mimicArmor.func_189416_e());
        MaterialRegistry.powerArmorMaterial.repairMaterial = new ItemStack(Blocks.field_150343_Z);
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enableWaterGear = config.getBoolean("PurpleArmor", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemPowerArmor.checkIfHelmOff(player);
            ItemPowerArmor.checkIfLegsOff(player);
        }
    }
}

