/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.component.playerext.ItemFoodCrafting;
import com.lothrazar.cyclicmagic.component.playerext.ItemFoodInventory;
import com.lothrazar.cyclicmagic.item.ItemAppleEmerald;
import com.lothrazar.cyclicmagic.item.ItemAppleLapis;
import com.lothrazar.cyclicmagic.item.ItemChorusCorrupted;
import com.lothrazar.cyclicmagic.item.ItemChorusGlowing;
import com.lothrazar.cyclicmagic.item.ItemHeartContainer;
import com.lothrazar.cyclicmagic.item.ItemHorseUpgrade;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.registry.AchievementRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemConsumeablesModule
extends BaseEventModule
implements IHasConfig {
    private boolean enableEmeraldApple;
    private boolean enableHeartContainer;
    private boolean enableInventoryCrafting;
    private boolean enableInventoryUpgrade;
    private boolean enableCorruptedChorus;
    private boolean enableHorseFoodUpgrades;
    private boolean enableGlowingChorus;
    private boolean enableLapisApple;

    @Override
    public void onPreInit() {
        if (this.enableHorseFoodUpgrades) {
            ItemHorseUpgrade emerald_carrot = new ItemHorseUpgrade(ItemHorseUpgrade.HorseUpgradeType.TYPE, new ItemStack(Items.field_151166_bC));
            ItemHorseUpgrade lapis_carrot = new ItemHorseUpgrade(ItemHorseUpgrade.HorseUpgradeType.VARIANT, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
            ItemHorseUpgrade diamond_carrot = new ItemHorseUpgrade(ItemHorseUpgrade.HorseUpgradeType.HEALTH, new ItemStack(Items.field_151045_i));
            ItemHorseUpgrade redstone_carrot = new ItemHorseUpgrade(ItemHorseUpgrade.HorseUpgradeType.SPEED, new ItemStack(Items.field_151137_ax));
            ItemHorseUpgrade ender_carrot = new ItemHorseUpgrade(ItemHorseUpgrade.HorseUpgradeType.JUMP, new ItemStack(Items.field_151061_bv));
            ItemRegistry.register(emerald_carrot, "horse_upgrade_type");
            ItemRegistry.register(lapis_carrot, "horse_upgrade_variant");
            ItemRegistry.register(diamond_carrot, "horse_upgrade_health");
            ItemRegistry.register(redstone_carrot, "horse_upgrade_speed");
            ItemRegistry.register(ender_carrot, "horse_upgrade_jump");
            ModCyclic.instance.events.register(this);
            AchievementRegistry.registerItemAchievement(diamond_carrot);
            ItemRegistry.registerWithJeiDescription(emerald_carrot);
            ItemRegistry.registerWithJeiDescription(lapis_carrot);
            ItemRegistry.registerWithJeiDescription(diamond_carrot);
            ItemRegistry.registerWithJeiDescription(redstone_carrot);
            ItemRegistry.registerWithJeiDescription(ender_carrot);
        }
        if (this.enableLapisApple) {
            ItemAppleLapis apple_lapis = new ItemAppleLapis();
            ItemRegistry.register(apple_lapis, "apple_lapis");
            ModCyclic.instance.events.register(apple_lapis);
        }
        if (this.enableEmeraldApple) {
            ItemAppleEmerald apple_emerald = new ItemAppleEmerald();
            ItemRegistry.register(apple_emerald, "apple_emerald");
            LootTableRegistry.registerLoot(apple_emerald);
            ItemRegistry.registerWithJeiDescription(apple_emerald);
            ModCyclic.instance.events.register(apple_emerald);
        }
        if (this.enableHeartContainer) {
            ItemHeartContainer heart_food = new ItemHeartContainer();
            ItemRegistry.register((Item)heart_food, "heart_food");
            ModCyclic.instance.events.register(heart_food);
            LootTableRegistry.registerLoot((Item)heart_food);
            LootTableRegistry.registerLoot((Item)heart_food, LootTableRegistry.ChestType.ENDCITY);
            LootTableRegistry.registerLoot((Item)heart_food, LootTableRegistry.ChestType.IGLOO);
            AchievementRegistry.registerItemAchievement((Item)heart_food);
            ItemRegistry.registerWithJeiDescription((Item)heart_food);
        }
        if (this.enableInventoryCrafting) {
            ItemFoodCrafting crafting_food = new ItemFoodCrafting();
            ItemRegistry.register((Item)crafting_food, "crafting_food");
            LootTableRegistry.registerLoot((Item)crafting_food);
            AchievementRegistry.registerItemAchievement((Item)crafting_food);
            ItemRegistry.registerWithJeiDescription((Item)crafting_food);
        }
        if (this.enableInventoryUpgrade) {
            ItemFoodInventory inventory_food = new ItemFoodInventory();
            ItemRegistry.register((Item)inventory_food, "inventory_food");
            LootTableRegistry.registerLoot((Item)inventory_food);
            AchievementRegistry.registerItemAchievement((Item)inventory_food);
            ItemRegistry.registerWithJeiDescription((Item)inventory_food);
        }
        if (this.enableCorruptedChorus) {
            ItemChorusCorrupted corrupted_chorus = new ItemChorusCorrupted();
            ItemRegistry.register((Item)corrupted_chorus, "corrupted_chorus");
            ModCyclic.instance.events.register(corrupted_chorus);
            LootTableRegistry.registerLoot((Item)corrupted_chorus);
            LootTableRegistry.registerLoot((Item)corrupted_chorus, LootTableRegistry.ChestType.ENDCITY);
            AchievementRegistry.registerItemAchievement((Item)corrupted_chorus);
            ItemRegistry.registerWithJeiDescription((Item)corrupted_chorus);
        }
        if (this.enableGlowingChorus) {
            ItemChorusGlowing glowing_chorus = new ItemChorusGlowing();
            ItemRegistry.register((Item)glowing_chorus, "glowing_chorus");
            ModCyclic.instance.events.register(glowing_chorus);
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)event.getEntity();
        ItemStack held = entityPlayer.func_184614_ca();
        if (held != null && held.func_77973_b() instanceof ItemHorseUpgrade && held.func_190916_E() > 0 && event.getTarget() instanceof AbstractHorse) {
            ItemHorseUpgrade.onHorseInteract((AbstractHorse)event.getTarget(), entityPlayer, held, (ItemHorseUpgrade)held.func_77973_b());
            event.setCanceled(true);
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enableLapisApple = config.getBoolean("LapisApple", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableGlowingChorus = config.getBoolean("GlowingChorus(Food)", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableEmeraldApple = config.getBoolean("EmeraldApple", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableHeartContainer = config.getBoolean("HeartContainer(food)", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableInventoryCrafting = config.getBoolean("InventoryCrafting(Food)", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableInventoryUpgrade = config.getBoolean("InventoryUpgrade(Food)", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableCorruptedChorus = config.getBoolean("CorruptedChorus(Food)", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableHorseFoodUpgrades = config.getBoolean("HorseFood", "cyclicmagic.content", true, "Set false to delete - requires restart");
        String category = "modpacks";
        ItemHorseUpgrade.HEARTS_MAX = config.getInt("HorseFood Max Hearts", category, 20, 1, 100, "Maximum number of upgraded hearts");
        ItemHorseUpgrade.JUMP_MAX = config.getInt("HorseFood Max Jump", category, 6, 1, 20, "Maximum value of jump.  Naturally spawned/bred horses seem to max out at 5.5");
        ItemHorseUpgrade.SPEED_MAX = config.getInt("HorseFood Max Speed", category, 50, 1, 99, "Maximum value of speed (this is NOT blocks/per second or anything like that)");
    }
}

