/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseModule;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerCreateModule
extends BaseModule
implements IHasConfig {
    private boolean extraVillagersEnabled;

    private EntityVillager.ITradeList[][] buildDruidTrades() {
        return new EntityVillager.ITradeList[][]{{new EntityVillager.EmeraldForItems(Items.field_179566_aV, new EntityVillager.PriceInfo(9, 12)), new EntityVillager.EmeraldForItems(Items.field_151034_e, new EntityVillager.PriceInfo(3, 6)), new EntityVillager.EmeraldForItems(Items.field_185164_cV, new EntityVillager.PriceInfo(8, 12))}, {new EntityVillager.EmeraldForItems(Items.field_151008_G, new EntityVillager.PriceInfo(12, 13)), new EntityVillager.EmeraldForItems(Items.field_151014_N, new EntityVillager.PriceInfo(50, 64)), new EntityVillager.EmeraldForItems(Items.field_151170_bI, new EntityVillager.PriceInfo(1, 3))}, {new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150338_P), new EntityVillager.PriceInfo(8, 12)), new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150337_Q), new EntityVillager.PriceInfo(8, 12))}, {new EntityVillager.EmeraldForItems(Items.field_151082_bd, new EntityVillager.PriceInfo(14, 17)), new EntityVillager.EmeraldForItems(Items.field_179558_bo, new EntityVillager.PriceInfo(14, 17)), new EntityVillager.EmeraldForItems(Items.field_151076_bf, new EntityVillager.PriceInfo(14, 17))}, {new EntityVillager.EmeraldForItems(Items.field_151164_bB, new EntityVillager.PriceInfo(1, 1)), new EntityVillager.EmeraldForItems(Items.field_151115_aP, new EntityVillager.PriceInfo(9, 12)), new EntityVillager.EmeraldForItems(Items.field_151070_bp, new EntityVillager.PriceInfo(3, 6))}, {new ListItemForEmeraldsFixed(new ItemStack((Block)Blocks.field_150349_c, 32), new EntityVillager.PriceInfo(1, 2)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150458_ak, 32), new EntityVillager.PriceInfo(1, 2)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150346_d, 32, BlockDirt.DirtType.PODZOL.func_176925_a()), new EntityVillager.PriceInfo(1, 2)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_185774_da, 32), new EntityVillager.PriceInfo(1, 2))}, {new ListItemForEmeraldsFixed(new ItemStack((Block)Blocks.field_150391_bh, 1), new EntityVillager.PriceInfo(12, 16)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150392_bi, 32), new EntityVillager.PriceInfo(1, 2)), new ListItemForEmeraldsFixed(new ItemStack((Block)Blocks.field_150354_m, 32, BlockSand.EnumType.RED_SAND.ordinal()), new EntityVillager.PriceInfo(1, 3)), new ListItemForEmeraldsFixed(new ItemStack(Items.field_151100_aR, 16, EnumDyeColor.BLACK.func_176767_b()), new EntityVillager.PriceInfo(1, 3))}};
    }

    private EntityVillager.ITradeList[][] buildSageTrades() {
        return new EntityVillager.ITradeList[][]{{new EntityVillager.EmeraldForItems(Items.field_151016_H, new EntityVillager.PriceInfo(5, 8)), new EntityVillager.EmeraldForItems(Items.field_151075_bm, new EntityVillager.PriceInfo(12, 16))}, {new EntityVillager.EmeraldForItems(Items.field_151103_aS, new EntityVillager.PriceInfo(8, 16)), new EntityVillager.EmeraldForItems(Items.field_179561_bm, new EntityVillager.PriceInfo(4, 12))}, {new EntityVillager.EmeraldForItems(Items.field_151072_bj, new EntityVillager.PriceInfo(8, 16)), new EntityVillager.EmeraldForItems(Items.field_151123_aH, new EntityVillager.PriceInfo(8, 16))}, {new EntityVillager.EmeraldForItems(Items.field_151073_bk, new EntityVillager.PriceInfo(1, 2)), new EntityVillager.EmeraldForItems(Items.field_151137_ax, new EntityVillager.PriceInfo(4, 6))}, {new EntityVillager.EmeraldForItems(Items.field_151114_aO, new EntityVillager.PriceInfo(6, 8)), new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(8, 12)), new EntityVillager.EmeraldForItems(Items.field_151079_bi, new EntityVillager.PriceInfo(12, 16))}, {new ListItemForEmeraldsFixed(new ItemStack(Items.field_151062_by, 8), new EntityVillager.PriceInfo(1, 4)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150435_aG, 16), new EntityVillager.PriceInfo(1, 1))}, {new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150371_ca, 16), new EntityVillager.PriceInfo(2, 4)), new ListItemForEmeraldsFixed(new ItemStack(Blocks.field_150343_Z, 16), new EntityVillager.PriceInfo(2, 4)), new ListItemForEmeraldsFixed(new ItemStack(Items.field_151115_aP, 4, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), new EntityVillager.PriceInfo(1, 2))}};
    }

    private void addVillager(String name, EntityVillager.ITradeList[][] trades) {
        VillagerRegistry.VillagerProfession prof = new VillagerRegistry.VillagerProfession("cyclicmagic:" + name, "cyclicmagic:textures/entity/villager/" + name + ".png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
        VillagerRegistry.instance().register(prof);
        VillagerRegistry.VillagerCareer villager = new VillagerRegistry.VillagerCareer(prof, name);
        for (int i = 0; i < trades.length; ++i) {
            villager.addTrade(i + 1, trades[i]);
        }
    }

    @Override
    public void onInit() {
        if (this.extraVillagersEnabled) {
            this.addVillager("sage", this.buildSageTrades());
            this.addVillager("druid", this.buildDruidTrades());
        }
    }

    @Override
    public void syncConfig(Configuration c) {
        String category = "cyclicmagic.villagers";
        c.addCustomCategoryComment(category, "Two new villagers with more trades");
        this.extraVillagersEnabled = c.getBoolean("SageAndDruidVillagers", category, true, "Adds more  villager types (Sage and Druid) with more trades such as gunpowder, blaze rods, beef, spider eyes, and more.  Spawn naturally and from mob eggs. ");
    }

    public static class ListItemForEmeraldsFixed
    implements EntityVillager.ITradeList {
        public ItemStack itemToBuy;
        public EntityVillager.PriceInfo priceInfo;

        public ListItemForEmeraldsFixed(Item par1Item, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = new ItemStack(par1Item);
            this.priceInfo = priceInfo;
        }

        public ListItemForEmeraldsFixed(ItemStack stack, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = stack;
            this.priceInfo = priceInfo;
        }

        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.func_179412_a(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(Items.field_151166_bC);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), -i, this.itemToBuy.func_77960_j());
            } else {
                itemstack = new ItemStack(Items.field_151166_bC, i, 0);
                itemstack1 = this.itemToBuy.func_77946_l();
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
        }
    }
}

