/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.proxy;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.IBlockHasTESR;
import com.lothrazar.cyclicmagic.entity.EntityGoldFurnaceMinecart;
import com.lothrazar.cyclicmagic.entity.EntityGoldMinecart;
import com.lothrazar.cyclicmagic.entity.EntityMinecartTurret;
import com.lothrazar.cyclicmagic.entity.EntityStoneMinecart;
import com.lothrazar.cyclicmagic.entity.RenderCyclicMinecart;
import com.lothrazar.cyclicmagic.entity.projectile.EntityBlazeBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDungeonEye;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamite;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteBlockSafe;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteMining;
import com.lothrazar.cyclicmagic.entity.projectile.EntityFishingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityHarvestBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityLightningballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityMagicNetEmpty;
import com.lothrazar.cyclicmagic.entity.projectile.EntityMagicNetFull;
import com.lothrazar.cyclicmagic.entity.projectile.EntityShearingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntitySnowballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityTorchBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityWaterBolt;
import com.lothrazar.cyclicmagic.entity.projectile.RenderProjectile;
import com.lothrazar.cyclicmagic.module.KeyInventoryShiftModule;
import com.lothrazar.cyclicmagic.proxy.CommonProxy;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding keyShiftUp;
    public static KeyBinding keyShiftDown;
    public static KeyBinding keyBarUp;
    public static KeyBinding keyBarDown;
    public static KeyBinding keyExtraInvo;
    public static KeyBinding keyExtraCraftin;
    static final String keyCategoryInventory = "key.categories.inventorycontrol";
    public static final String[] NET_CLIENT_HANDLER;
    public static final String[] CURRENT_GAME_TYPE;

    @Override
    public void preInit() {
        this.registerEntities();
    }

    @Override
    public void init() {
        this.registerModels();
        this.registerKeys();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private void registerKeys() {
        if (KeyInventoryShiftModule.enableInvoKeys) {
            keyShiftUp = new KeyBinding("key.columnshiftup", 21, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftUp);
            keyShiftDown = new KeyBinding("key.columnshiftdown", 35, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftDown);
            keyBarUp = new KeyBinding("key.columnbarup", 26, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarUp);
            keyBarDown = new KeyBinding("key.columnbardown", 27, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarDown);
            keyExtraInvo = new KeyBinding("key.keyExtraInvo", 19, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyExtraInvo);
            keyExtraCraftin = new KeyBinding("key.keyExtraCraftin", 24, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyExtraCraftin);
        }
    }

    private void registerEntities() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_GOLD);
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldFurnaceMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_GOLD_FURNACE);
        RenderingRegistry.registerEntityRenderingHandler(EntityStoneMinecart.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_STONE_FURNACE);
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartTurret.class, (IRenderFactory)RenderCyclicMinecart.FACTORY_TURRET);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningballBolt.class, (IRenderFactory)RenderProjectile.FACTORY_LIGHTNING);
        RenderingRegistry.registerEntityRenderingHandler(EntityHarvestBolt.class, (IRenderFactory)RenderProjectile.FACTORY_HARVEST);
        RenderingRegistry.registerEntityRenderingHandler(EntityWaterBolt.class, (IRenderFactory)RenderProjectile.FACTORY_WATER);
        RenderingRegistry.registerEntityRenderingHandler(EntitySnowballBolt.class, (IRenderFactory)RenderProjectile.FACTORY_SNOW);
        RenderingRegistry.registerEntityRenderingHandler(EntityTorchBolt.class, (IRenderFactory)RenderProjectile.FACTORY_TORCH);
        RenderingRegistry.registerEntityRenderingHandler(EntityFishingBolt.class, (IRenderFactory)RenderProjectile.FACTORY_FISH);
        RenderingRegistry.registerEntityRenderingHandler(EntityShearingBolt.class, (IRenderFactory)RenderProjectile.FACTORY_SHEAR);
        RenderingRegistry.registerEntityRenderingHandler(EntityDungeonEye.class, (IRenderFactory)RenderProjectile.FACTORY_DUNG);
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (IRenderFactory)RenderProjectile.FACTORY_DYN);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeBolt.class, (IRenderFactory)RenderProjectile.FACTORY_FIRE);
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamiteMining.class, (IRenderFactory)RenderProjectile.FACTORY_DYNMINING);
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamiteBlockSafe.class, (IRenderFactory)RenderProjectile.FACTORY_DYNSAVE);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicNetFull.class, (IRenderFactory)RenderProjectile.FACTORY_BALL);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicNetEmpty.class, (IRenderFactory)RenderProjectile.FACTORY_BALLEMPTY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumFacing getSideMouseover(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.field_178784_b;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverSingle() {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return null;
        }
        return mouseOver.func_178782_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverExact(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.func_178782_a();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverOffset(int max) {
        BlockPos blockPos;
        EntityPlayerSP player = (EntityPlayerSP)this.getClientPlayer();
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null && mouseOver.field_178784_b != null && (blockPos = mouseOver.func_178782_a()) != null && player != null && player.func_130014_f_().func_180495_p(blockPos) != null && !player.func_130014_f_().func_175623_d(blockPos)) {
            return blockPos.func_177972_a(mouseOver.field_178784_b);
        }
        return null;
    }

    private void registerModels() {
        String name;
        Item item;
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Block b : BlockRegistry.blocks) {
            item = Item.func_150898_a((Block)b);
            name = "cyclicmagic:" + b.func_149739_a().replaceAll("tile.", "");
            mesher.func_178086_a(item, 0, new ModelResourceLocation(name, "inventory"));
            if (!(b instanceof IBlockHasTESR)) continue;
            ((IBlockHasTESR)b).initModel();
        }
        for (String key : ItemRegistry.itemMap.keySet()) {
            item = ItemRegistry.itemMap.get(key);
            name = "cyclicmagic:" + item.func_77658_a().replaceAll("item.", "");
            mesher.func_178086_a(item, 0, new ModelResourceLocation(name, "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClientPlayerData(MessageContext ctx, NBTTagCompound tags) {
        CapabilityRegistry.IPlayerExtendedProperties props;
        EntityPlayer p = this.getPlayerEntity(ctx);
        if (p != null && (props = CapabilityRegistry.getPlayerProperties(this.getClientPlayer())) != null) {
            props.setDataFromNBT(tags);
        }
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.getClientPlayer() : super.getPlayerEntity(ctx);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnScreen(ItemStack current, int x, int y) {
        if (current == null) {
            return;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        itemRender.func_180450_b(current, x, y);
        RenderHelper.func_74518_a();
    }

    @Override
    public void renderItemOnGui(ItemStack stack, RenderItem itemRender, FontRenderer fontRendererObj, int x, int y) {
        if (stack == null) {
            return;
        }
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_175030_a(fontRendererObj, stack, x, y);
    }

    @Override
    public void setPlayerReach(EntityPlayer player, int currentReach) {
        super.setPlayerReach(player, currentReach);
        Minecraft mc = Minecraft.func_71410_x();
        try {
            if (player == mc.field_71439_g && !(mc.field_71442_b instanceof ReachPlayerController)) {
                GameType type = (GameType)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])CURRENT_GAME_TYPE);
                NetHandlerPlayClient netHandler = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])NET_CLIENT_HANDLER);
                ReachPlayerController controller = new ReachPlayerController(mc, netHandler);
                boolean isFlying = player.field_71075_bZ.field_75100_b;
                boolean allowFlying = player.field_71075_bZ.field_75101_c;
                controller.func_78746_a(type);
                player.field_71075_bZ.field_75100_b = isFlying;
                player.field_71075_bZ.field_75101_c = allowFlying;
                mc.field_71442_b = controller;
            }
            ((ReachPlayerController)mc.field_71442_b).setReachDistance(currentReach);
        }
        catch (Exception e) {
            ModCyclic.logger.info("Error setting reach : " + e);
        }
    }

    static {
        NET_CLIENT_HANDLER = new String[]{"connection", "field_78774_b"};
        CURRENT_GAME_TYPE = new String[]{"currentGameType", "field_78779_k"};
    }

    @SideOnly(value=Side.CLIENT)
    public class ReachPlayerController
    extends PlayerControllerMP {
        private float distance;

        public ReachPlayerController(Minecraft mcIn, NetHandlerPlayClient netHandler) {
            super(mcIn, netHandler);
            this.distance = 0.0f;
        }

        public float func_78757_d() {
            return this.distance;
        }

        public void setReachDistance(float f) {
            this.distance = f;
        }
    }
}

