/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class GuideRegistry {
    private static List<GuideItem> items = new ArrayList<GuideItem>();
    private static final String SUFFIX = ".guide";

    public static GuideItem register(Enchantment ench, @Nonnull List<String> args) {
        args.add(ench.func_77324_c().name().toLowerCase().replace("_", " "));
        return GuideRegistry.register(GuideCategory.ENCHANT, new ItemStack((Item)Items.field_151134_bR), ench.func_77320_a(), ench.func_77320_a() + SUFFIX, null, args);
    }

    public static GuideItem register(GuideCategory cat, Block block) {
        return GuideRegistry.register(cat, block, null, null);
    }

    public static GuideItem register(GuideCategory cat, Block block, @Nullable IRecipe recipe, @Nullable List<String> args) {
        String pageTitle = block.func_149739_a() + ".name";
        String text = block.func_149739_a() + SUFFIX;
        return GuideRegistry.register(cat, new ItemStack(block), pageTitle, text, recipe, args);
    }

    public static GuideItem register(GuideCategory cat, Item item) {
        return GuideRegistry.register(cat, item, null, null);
    }

    public static GuideItem register(GuideCategory cat, Item item, @Nullable IRecipe recipe, @Nullable List<String> args) {
        String pageTitle = item.func_77658_a() + ".name";
        String above = item.func_77658_a() + SUFFIX;
        return GuideRegistry.register(cat, new ItemStack(item), pageTitle, above, recipe, args);
    }

    public static GuideItem register(GuideCategory cat, ItemStack icon, String title, String text) {
        return GuideRegistry.register(cat, icon, title, text, null, null);
    }

    public static GuideItem register(GuideCategory cat, @Nonnull ItemStack icon, String title, String text, @Nullable IRecipe recipes, @Nullable List<String> args) {
        if (args != null && args.size() > 0) {
            text = UtilChat.lang(text);
            for (int i = 0; i < args.size(); ++i) {
                text = text.replace("$" + i, args.get(i));
            }
        }
        GuideItem itempage = new GuideItem(cat, icon, title, text, recipes);
        items.add(itempage);
        return itempage;
    }

    public static GuideItem register(GuideCategory cat, ItemStack icon, String title) {
        GuideItem itempage = new GuideItem(cat, icon, title, null, null);
        items.add(itempage);
        return itempage;
    }

    public static List<GuideItem> getItems() {
        return items;
    }

    public static class GuideItem {
        public GuideCategory cat;
        public ItemStack icon;
        public String title;
        public List<GuidePage> pages = new ArrayList<GuidePage>();

        public GuideItem(@Nonnull GuideCategory cat, @Nonnull ItemStack icon, @Nonnull String title, @Nonnull String text, @Nullable IRecipe recipe) {
            this.cat = cat;
            this.icon = icon;
            this.title = UtilChat.lang(title);
            if (text != null) {
                this.pages.add(new GuidePage(UtilChat.lang(text)));
            }
            if (recipe != null) {
                this.pages.add(new GuidePage(recipe));
            }
        }

        public void addRecipePage(IRecipe t) {
            if (t == null) {
                return;
            }
            this.pages.add(new GuidePage(t));
        }

        public void addRecipePage(BrewingRecipe t) {
            if (t == null) {
                return;
            }
            this.pages.add(new GuidePage(t));
        }

        public void addTextPage(String t) {
            this.pages.add(new GuidePage(t));
        }
    }

    public static class GuidePage {
        public String text = null;
        public IRecipe recipe = null;
        public BrewingRecipe brewRecipe = null;

        public GuidePage(String t) {
            this.text = t;
        }

        public GuidePage(IRecipe t) {
            this.recipe = t;
        }

        public GuidePage(BrewingRecipe t) {
            this.brewRecipe = t;
        }
    }

    public static enum GuideCategory {
        BLOCK,
        ITEM,
        WORLD,
        GEAR,
        POTION,
        ENCHANT,
        BLOCKMACHINE,
        BLOCKPLATE,
        ITEMBAUBLES,
        ITEMTHROW,
        TRANSPORT;


        public String text() {
            return "guide.category." + this.name().toLowerCase();
        }

        public ItemStack icon() {
            switch (this) {
                case BLOCK: {
                    return new ItemStack(Blocks.field_150477_bB);
                }
                case BLOCKMACHINE: {
                    return new ItemStack(Blocks.field_150460_al);
                }
                case ENCHANT: {
                    return new ItemStack((Item)Items.field_151134_bR);
                }
                case GEAR: {
                    return new ItemStack(Items.field_151048_u);
                }
                case ITEM: {
                    return new ItemStack(Items.field_151055_y);
                }
                case POTION: {
                    return new ItemStack((Item)Items.field_151068_bn);
                }
                case WORLD: {
                    return new ItemStack(Blocks.field_150352_o);
                }
                case BLOCKPLATE: {
                    return new ItemStack(Blocks.field_150443_bT);
                }
                case ITEMBAUBLES: {
                    return new ItemStack(Items.field_190929_cY);
                }
                case ITEMTHROW: {
                    return new ItemStack(Items.field_185160_cR);
                }
                case TRANSPORT: {
                    return new ItemStack(Items.field_151109_aJ);
                }
            }
            return new ItemStack(Blocks.field_150346_d);
        }
    }
}

