/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.potion.PotionBase;
import com.lothrazar.cyclicmagic.potion.PotionBounce;
import com.lothrazar.cyclicmagic.potion.PotionEnder;
import com.lothrazar.cyclicmagic.potion.PotionMagnet;
import com.lothrazar.cyclicmagic.potion.PotionSlowfall;
import com.lothrazar.cyclicmagic.potion.PotionSnow;
import com.lothrazar.cyclicmagic.potion.PotionSwimSpeed;
import com.lothrazar.cyclicmagic.potion.PotionWaterwalk;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class PotionEffectRegistry {
    public static final PotionBase SLOWFALL = new PotionSlowfall("slowfall", true, 0);
    public static final PotionBase MAGNET = new PotionMagnet("magnet", true, 0);
    public static final PotionBase ENDER = new PotionEnder("ender", true, 0);
    public static final PotionBase WATERWALK = new PotionWaterwalk("waterwalk", true, 0);
    public static final PotionBase SNOW = new PotionSnow("snow", true, 0);
    public static final PotionBase SWIMSPEED = new PotionSwimSpeed("swimspeed", true, 0);
    public static final PotionBase BOUNCE = new PotionBounce("bounce", true, 0);
    public static ArrayList<PotionBase> potionEffects = new ArrayList();

    public static void register() {
        PotionEffectRegistry.registerPotionEffect(MAGNET);
        PotionEffectRegistry.registerPotionEffect(ENDER);
        PotionEffectRegistry.registerPotionEffect(WATERWALK);
        PotionEffectRegistry.registerPotionEffect(SLOWFALL);
        PotionEffectRegistry.registerPotionEffect(SNOW);
        PotionEffectRegistry.registerPotionEffect(SWIMSPEED);
        PotionEffectRegistry.registerPotionEffect(BOUNCE);
    }

    public static void registerPotionEffect(PotionBase effect) {
        GameRegistry.register((IForgeRegistryEntry)effect, (ResourceLocation)effect.getIcon());
        potionEffects.add(effect);
        ModCyclic.instance.events.register((Object)effect);
    }

    public static String getStrForLevel(int lvl) {
        switch (lvl) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return "";
    }

    public static enum PotionType {
        NORMAL,
        POWERED,
        LONG;

    }
}

