/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeRegistry {
    public static IRecipe addShapelessRecipe(ItemStack output, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof String) {
                return RecipeRegistry.addShapelessOreRecipe(output, recipeComponents);
            }
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add(new ItemStack((Block)object));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(output, (List)list);
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }

    public static IRecipe addShapedRecipe(@Nonnull ItemStack output, Object ... recipeComponents) {
        for (Object object : recipeComponents) {
            if (!(object instanceof String)) continue;
            return RecipeRegistry.addShapedOreRecipe(output, recipeComponents);
        }
        return GameRegistry.addShapedRecipe((ItemStack)output, (Object[])recipeComponents);
    }

    private static IRecipe addShapedOreRecipe(ItemStack stack, Object ... recipeComponents) {
        ShapedOreRecipe r = new ShapedOreRecipe(stack, recipeComponents);
        GameRegistry.addRecipe((IRecipe)r);
        return r;
    }

    private static IRecipe addShapelessOreRecipe(ItemStack output, Object ... recipeComponents) {
        ShapelessOreRecipe r = new ShapelessOreRecipe(output, recipeComponents);
        GameRegistry.addRecipe((IRecipe)r);
        return r;
    }
}

