/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class UtilFluid {
    public static FluidActionResult fillContainer(World world, BlockPos pos, ItemStack stackIn, EnumFacing facing) {
        return FluidUtil.tryPickUpFluid((ItemStack)stackIn, null, (World)world, (BlockPos)pos, (EnumFacing)facing);
    }

    public static ItemStack dumpContainer(World world, BlockPos pos, ItemStack stackIn) {
        ItemStack dispensedStack = stackIn.func_77946_l();
        dispensedStack.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)dispensedStack);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        if (fluidStack != null && fluidStack.amount >= 1000 && FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (ItemStack)dispensedStack, (FluidStack)fluidStack).isSuccess()) {
            fluidHandler.drain(1000, true);
            ItemStack returnMe = fluidHandler.getContainer();
            return returnMe;
        }
        return null;
    }

    public static ItemStack drainOneBucket(ItemStack d) {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)d);
        if (fluidHandler == null) {
            return d;
        }
        fluidHandler.drain(1000, true);
        return fluidHandler.getContainer();
    }

    public static boolean isEmptyOfFluid(ItemStack returnMe) {
        return FluidUtil.getFluidContained((ItemStack)returnMe) == null;
    }

    public static boolean stackHasFluidHandler(ItemStack stackIn) {
        return FluidUtil.getFluidHandler((ItemStack)stackIn) != null;
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing side) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
    }

    public static boolean interactWithFluidHandler(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (World)world, (BlockPos)pos, (EnumFacing)side);
    }
}

