/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.config.Configuration;

public class UtilHarvestCrops {
    private static String[] blacklist;

    public static int harvestArea(World world, BlockPos pos, int hRadius, HarvestSetting conf) {
        int x = pos.func_177958_n();
        int eventy = pos.func_177956_o();
        int z = pos.func_177952_p();
        int xMin = x - hRadius;
        int xMax = x + hRadius;
        int zMin = z - hRadius;
        int zMax = z + hRadius;
        int countHarvested = 0;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                BlockPos posCurrent = new BlockPos(xLoop, eventy, zLoop);
                if (world.func_175623_d(posCurrent) || !UtilHarvestCrops.harvestSingle(world, posCurrent, conf)) continue;
                ++countHarvested;
            }
        }
        return countHarvested;
    }

    public static boolean harvestSingle(World world, BlockPos posCurrent, HarvestSetting conf) {
        int age;
        boolean doBreakAbove = false;
        boolean doBreakBelow = false;
        boolean doBreak = false;
        IBlockState stateReplant = null;
        IBlockState blockState = world.func_180495_p(posCurrent);
        if (blockState == null) {
            return false;
        }
        boolean addDropsToList = true;
        Block blockCheck = blockState.func_177230_c();
        if (blockCheck == Blocks.field_150350_a) {
            return false;
        }
        Item seedItem = blockCheck.func_180660_a(blockCheck.func_176223_P(), world.field_73012_v, 0);
        if (UtilHarvestCrops.isItemInBlacklist(seedItem)) {
            return false;
        }
        String blockClassString = blockCheck.getClass().getName();
        IBlockState bsAbove = world.func_180495_p(posCurrent.func_177984_a());
        IBlockState bsBelow = world.func_180495_p(posCurrent.func_177977_b());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (blockCheck instanceof BlockNetherWart && conf.doesCrops && (age = ((Integer)blockState.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) == 3) {
            doBreak = true;
            stateReplant = blockCheck.func_176223_P();
        }
        if (blockCheck instanceof BlockCocoa) {
            if (conf.doesCrops && (age = ((Integer)blockState.func_177229_b((IProperty)BlockCocoa.field_176501_a)).intValue()) == 2) {
                doBreak = true;
                stateReplant = blockCheck.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, blockState.func_177229_b((IProperty)BlockCocoa.field_185512_D));
            }
        } else if (blockCheck instanceof BlockStem) {
            if (conf.doesStem) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockSapling) {
            if (conf.doesSapling) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockTallGrass) {
            if (conf.doesTallgrass) {
                doBreak = true;
                if (blockCheck instanceof BlockTallGrass && bsAbove != null && bsAbove.func_177230_c() instanceof BlockTallGrass) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockTallGrass && bsBelow != null && bsBelow.func_177230_c() instanceof BlockTallGrass) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockDoublePlant) {
            if (conf.doesTallgrass) {
                doBreak = true;
                if (blockCheck instanceof BlockDoublePlant && bsAbove != null && bsAbove.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockDoublePlant && bsBelow != null && bsBelow.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockMushroom) {
            if (conf.doesMushroom) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150423_aK) {
            if (conf.doesPumpkinBlocks) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150440_ba) {
            if (conf.doesMelonBlocks) {
                doBreak = false;
                world.func_175655_b(posCurrent, false);
                UtilItemStack.dropItemStackInWorld(world, posCurrent, Blocks.field_150440_ba);
            }
        } else if (blockCheck == Blocks.field_150328_O || blockCheck == Blocks.field_150327_N || blockCheck instanceof BlockFlower || blockClassString.equals("shadows.plants.block.PlantBase") || blockClassString.equals("shadows.plants.block.internal.cosmetic.BlockHarvestable") || blockClassString.equals("shadows.plants.block.internal.cosmetic.BlockMetaBush") || blockClassString.equals("de.ellpeck.actuallyadditions.mod.blocks.BlockBlackLotus") || blockClassString.equals("de.ellpeck.actuallyadditions.mod.blocks.base.BlockWildPlant") || blockClassString.equals("biomesoplenty.common.block.BlockBOPMushroom") || blockClassString.equals("rustic.common.blocks.crops.Herbs$1")) {
            if (conf.doesFlowers) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockLeaves) {
            if (conf.doesLeaves) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150434_aF && bsBelow != null && bsBelow.func_177230_c() == Blocks.field_150434_aF) {
            if (conf.doesCactus) {
                doBreak = true;
                if (bsAbove != null && bsAbove.func_177230_c() == Blocks.field_150434_aF) {
                    doBreakAbove = true;
                }
            }
        } else if (blockCheck == Blocks.field_150436_aH && bsBelow != null && bsBelow.func_177230_c() == Blocks.field_150436_aH) {
            if (conf.doesReeds) {
                doBreak = true;
                if (bsAbove != null && bsAbove.func_177230_c() == Blocks.field_150436_aH) {
                    doBreakAbove = true;
                }
            }
        } else if (blockCheck instanceof IGrowable) {
            IGrowable plant;
            if (conf.doesCrops && !(plant = (IGrowable)blockCheck).func_176473_a(world, posCurrent, blockState, world.field_72995_K)) {
                doBreak = true;
                stateReplant = blockCheck.func_176223_P();
            }
        } else if (blockCheck instanceof IShearable && conf.doesIShearable) {
            addDropsToList = false;
            drops.addAll(((IShearable)blockCheck).onSheared(ItemStack.field_190927_a, (IBlockAccess)world, posCurrent, 0));
            doBreak = true;
        }
        if (doBreak) {
            block62: {
                world.func_175655_b(posCurrent, false);
                if (addDropsToList) {
                    drops.addAll(blockCheck.getDrops((IBlockAccess)world, posCurrent, blockState, 0));
                }
                if (doBreakAbove) {
                    world.func_175655_b(posCurrent.func_177984_a(), false);
                }
                if (doBreakBelow) {
                    world.func_175655_b(posCurrent.func_177977_b(), false);
                }
                if (stateReplant != null) {
                    world.func_175656_a(posCurrent, stateReplant);
                    try {
                        if (drops.size() <= 1 || seedItem == null) break block62;
                        Iterator iterator = drops.iterator();
                        while (iterator.hasNext()) {
                            ItemStack drop = (ItemStack)iterator.next();
                            if (drop.func_77973_b() != seedItem) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    catch (Exception e) {
                        ModCyclic.logger.error("Crop could not be harvested by Cyclic, contact both mod authors");
                        ModCyclic.logger.error(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            if (drops.size() > 0) {
                if (conf.dropInPlace) {
                    for (ItemStack drop : drops) {
                        UtilItemStack.dropItemStackInWorld(world, posCurrent, drop);
                    }
                } else {
                    conf.setDrops(drops);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isItemInBlacklist(Item seedItem) {
        String itemName = UtilItemStack.getStringForItem(seedItem);
        for (String s : blacklist) {
            if (s == null || !s.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static void syncConfig(Configuration config) {
        String category = "modpacks";
        String[] deflist = new String[]{"terraqueous:pergola"};
        blacklist = config.getStringList("HarvesterBlacklist", category, deflist, "Crops & bushes that are blocked from harvesting (Garden Scythe and Harvester).  Put an item that gets dropped to blacklist the harvest.  For example, add the item minecraft:potato to stop those from working");
    }

    public static class HarvestSetting {
        public boolean doesStem = false;
        public boolean doesSapling = false;
        public boolean doesMushroom = false;
        public boolean doesPumpkinBlocks = false;
        public boolean doesMelonBlocks = false;
        public boolean doesFlowers = false;
        public boolean doesLeaves = false;
        public boolean doesCrops = false;
        public boolean doesTallgrass = false;
        public boolean doesCactus = false;
        public boolean doesReeds = false;
        public boolean dropInPlace = true;
        public boolean doesIShearable = false;
        public List<ItemStack> drops;

        public String toString() {
            String s = "";
            s = s + "doesHarvestStem = " + this.doesStem + System.lineSeparator();
            s = s + "doesHarvestSapling = " + this.doesSapling + System.lineSeparator();
            s = s + "doesHarvestMushroom = " + this.doesMushroom + System.lineSeparator();
            s = s + "doesPumpkinBlocks = " + this.doesPumpkinBlocks + System.lineSeparator();
            s = s + "doesMelonBlocks = " + this.doesMelonBlocks + System.lineSeparator();
            s = s + "doesFlowers = " + this.doesFlowers + System.lineSeparator();
            s = s + "doesCrops = " + this.doesCrops + System.lineSeparator();
            s = s + "doesHarvestTallgrass = " + this.doesTallgrass + System.lineSeparator();
            return s;
        }

        public void setDrops(List<ItemStack> d) {
            this.drops = d;
        }
    }
}

