/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class UtilItemStack {
    public static boolean canMerge(ItemStack chestItem, ItemStack bagItem) {
        if (chestItem.func_190926_b() || bagItem.func_190926_b()) {
            return false;
        }
        return bagItem.func_77973_b().equals(chestItem.func_77973_b()) && bagItem.func_77952_i() == chestItem.func_77952_i() && ItemStack.func_77970_a((ItemStack)bagItem, (ItemStack)chestItem);
    }

    public static int mergeItemsBetweenStacks(ItemStack takeFrom, ItemStack moveTo) {
        int room = moveTo.func_77976_d() - moveTo.func_190916_E();
        int moveover = 0;
        if (room > 0) {
            moveover = Math.min(takeFrom.func_190916_E(), room);
            moveTo.func_190917_f(moveover);
            takeFrom.func_190918_g(moveover);
        }
        return moveover;
    }

    public static boolean isEmpty(ItemStack is) {
        return is == null || is.func_190926_b() || is == ItemStack.field_190927_a;
    }

    public static int getMaxDmgFraction(Item tool, int d) {
        return tool.func_77612_l() - MathHelper.func_76141_d((float)(tool.func_77612_l() / d));
    }

    public static void damageItem(EntityLivingBase p, ItemStack s) {
        if (p instanceof EntityPlayer) {
            UtilItemStack.damageItem((EntityPlayer)p, s);
        } else {
            s.func_77972_a(1, p);
        }
    }

    public static void damageItem(EntityPlayer p, ItemStack s) {
        if (!p.field_71075_bZ.field_75098_d) {
            s.func_77972_a(1, (EntityLivingBase)p);
        }
    }

    public static String getRawName(Item item) {
        return item.func_77658_a().replaceAll("item.", "");
    }

    public static IBlockState getStateFromMeta(Block b, int meta) {
        return b.func_176203_a(meta);
    }

    public static float getPlayerRelativeBlockHardness(Block b, IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        return b.func_180647_a(state, player, worldIn, pos);
    }

    public static float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        return state.func_177230_c().func_176195_g(state, worldIn, pos);
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Block block) {
        return UtilItemStack.dropItemStackInWorld(worldObj, pos, new ItemStack(block));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Item item) {
        return UtilItemStack.dropItemStackInWorld(worldObj, pos, new ItemStack(item));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, ItemStack stack) {
        EntityItem entityItem = new EntityItem(worldObj, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        if (!worldObj.field_72995_K) {
            worldObj.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }

    public static void dropItemStacksInWorld(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            UtilItemStack.dropItemStackInWorld(world, pos, s);
        }
    }

    @Nonnull
    public static String getStringForItemStack(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a() + "/" + itemStack.func_77960_j();
    }

    public static String getStringForItem(Item item) {
        if (item == null || item.getRegistryName() == null) {
            return "";
        }
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a();
    }

    public static String getStringForBlock(Block b) {
        return b.getRegistryName().func_110624_b() + ":" + b.getRegistryName().func_110623_a();
    }

    public static void dropBlockState(World world, BlockPos position, IBlockState current) {
        if (!world.field_72995_K && current.func_177230_c() != Blocks.field_150350_a) {
            UtilItemStack.dropItemStackInWorld(world, position, UtilItemStack.getSilkTouchDrop(current));
        }
    }

    public static IBlockState getStateFromStack(ItemStack stack) {
        Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
        return UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j());
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }
}

