/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.net.PacketParticleAtPosition;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class UtilParticle {
    private static final int count = 12;
    private static final double RANDOM_HORIZ = 0.8;
    private static final double RANDOM_VERT = 1.5;

    public static void spawnParticle(World world, EnumParticleTypes sparkle, BlockPos pos, int c) {
        UtilParticle.spawnParticle(world, sparkle, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), c);
    }

    public static void spawnParticleNarrow(World world, EnumParticleTypes sparkle, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int countparticles = 0; countparticles <= 12; ++countparticles) {
            world.func_175688_a(sparkle, (double)x + UtilParticle.getHorizRandom(world, 0.2), (double)y + UtilParticle.getVertRandom(world, 0.5), (double)z + UtilParticle.getHorizRandom(world, 0.2), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void spawnParticle(World world, EnumParticleTypes sparkle, double x, double y, double z, int count) {
        if (world.field_72995_K) {
            for (int countparticles = 0; countparticles <= count; ++countparticles) {
                world.func_175688_a(sparkle, x + UtilParticle.getHorizRandom(world, 0.8), y + UtilParticle.getVertRandom(world, 1.5), z + UtilParticle.getHorizRandom(world, 0.8), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            UtilParticle.spawnParticlePacket(sparkle, new BlockPos(x, y, z));
        }
    }

    private static double getVertRandom(World world, double rando) {
        return world.field_73012_v.nextDouble() * rando - 0.1;
    }

    private static double getHorizRandom(World world, double rando) {
        return (world.field_73012_v.nextDouble() - 0.5) * rando;
    }

    public static void spawnParticle(World world, EnumParticleTypes sparkle, double x, double y, double z) {
        UtilParticle.spawnParticle(world, sparkle, x, y, z, 12);
    }

    public static void spawnParticle(World world, EnumParticleTypes sparkle, Entity entity) {
        UtilParticle.spawnParticle(world, sparkle, entity.func_180425_c());
    }

    public static void spawnParticle(World world, EnumParticleTypes sparkle, BlockPos pos) {
        if (pos == null) {
            return;
        }
        UtilParticle.spawnParticle(world, sparkle, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnParticleBeam(World world, EnumParticleTypes sparkle, BlockPos start, BlockPos end, int count) {
        float dX = end.func_177958_n() - start.func_177958_n();
        float dY = end.func_177956_o() - start.func_177956_o();
        float dZ = end.func_177952_p() - start.func_177952_p();
        for (float t = 0.0f; t < 1.0f; t += 0.05f) {
            float x = (float)start.func_177958_n() + dX * t;
            float y = (float)start.func_177956_o() + dY * t;
            float z = (float)start.func_177952_p() + dZ * t;
            UtilParticle.spawnParticle(world, sparkle, x, y, z, count);
        }
    }

    public static void spawnParticlePacket(EnumParticleTypes particle, BlockPos position) {
        ModCyclic.network.sendToAll((IMessage)new PacketParticleAtPosition(position, particle.func_179348_c(), 12));
    }
}

