/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.google.common.io.Files;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.component.playerext.storage.InventoryPlayerExtended;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class UtilPlayerInventoryFilestorage {
    public static HashSet<Integer> playerEntityIds = new HashSet();
    private static HashMap<String, InventoryPlayerExtended> playerItems = new HashMap();
    public static final String ext = "invo";
    public static final String extback = "backup";
    public static final String regex = "[^a-zA-Z0-9_]";

    public static void playerSetupOnLoad(PlayerEvent.LoadFromFile event) {
        File fileNew;
        EntityPlayer player = event.getEntityPlayer();
        UtilPlayerInventoryFilestorage.clearPlayerInventory(player);
        File playerFile = UtilPlayerInventoryFilestorage.getPlayerFile(ext, event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString());
        if (!playerFile.exists() && (fileNew = event.getPlayerFile(ext)).exists()) {
            try {
                Files.copy((File)fileNew, (File)playerFile);
                ModCyclic.logger.info("Using and converting UUID savefile for " + player.getDisplayNameString());
                fileNew.delete();
                File fb = event.getPlayerFile(extback);
                if (fb.exists()) {
                    fb.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        UtilPlayerInventoryFilestorage.loadPlayerInventory(event.getEntityPlayer(), playerFile, UtilPlayerInventoryFilestorage.getPlayerFile(extback, event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString()));
        playerEntityIds.add(event.getEntityPlayer().func_145782_y());
    }

    public static void clearPlayerInventory(EntityPlayer player) {
        playerItems.remove(player.getDisplayNameString());
    }

    public static InventoryPlayerExtended getPlayerInventory(EntityPlayer player) {
        if (!playerItems.containsKey(player.getDisplayNameString())) {
            InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
            playerItems.put(player.getDisplayNameString(), inventory);
        }
        return playerItems.get(player.getDisplayNameString());
    }

    public static ItemStack getPlayerInventoryStack(EntityPlayer player, int slot) {
        return UtilPlayerInventoryFilestorage.getPlayerInventory(player).func_70301_a(slot);
    }

    public static void setPlayerInventoryStack(EntityPlayer player, int slot, ItemStack itemStack) {
        UtilPlayerInventoryFilestorage.getPlayerInventory((EntityPlayer)player).inv.set(slot, (Object)itemStack);
    }

    public static void setPlayerInventory(EntityPlayer player, InventoryPlayerExtended inventory) {
        playerItems.put(player.getDisplayNameString(), inventory);
    }

    public static void loadPlayerInventory(EntityPlayer player, File file1, File file2) {
        if (player != null && !player.func_130014_f_().field_72995_K) {
            try {
                FileInputStream fileinputstream;
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (file1 == null || !file1.exists() || data == null || data.func_82582_d()) {
                    ModCyclic.logger.error("Data not found for " + player.getDisplayNameString() + ". Trying to load backup data.");
                    if (file2 != null && file2.exists()) {
                        try {
                            fileinputstream = new FileInputStream(file2);
                            data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            save = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (data != null) {
                    InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
                    inventory.readNBT(data);
                    playerItems.put(player.getDisplayNameString(), inventory);
                    if (save) {
                        UtilPlayerInventoryFilestorage.savePlayerItems(player, file1, file2);
                    }
                }
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error loading player extended inventory");
                e.printStackTrace();
            }
        }
    }

    public static void savePlayerItems(EntityPlayer player, File file1, File file2) {
        block11: {
            if (player != null && !player.func_130014_f_().field_72995_K) {
                try {
                    if (file1 != null && file1.exists()) {
                        try {
                            Files.copy((File)file1, (File)file2);
                        }
                        catch (Exception e) {
                            ModCyclic.logger.error("Could not backup old file for player " + player.getDisplayNameString());
                        }
                    }
                    try {
                        if (file1 != null) {
                            InventoryPlayerExtended inventory = UtilPlayerInventoryFilestorage.getPlayerInventory(player);
                            NBTTagCompound data = new NBTTagCompound();
                            inventory.saveNBT(data);
                            FileOutputStream fileoutputstream = new FileOutputStream(file1);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception e) {
                        ModCyclic.logger.error("Could not save file for player " + player.getDisplayNameString());
                        e.printStackTrace();
                        if (!file1.exists()) break block11;
                        try {
                            file1.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception1) {
                    ModCyclic.logger.error("Error saving inventory");
                    exception1.printStackTrace();
                }
            }
        }
    }

    public static File getPlayerFile(String suffix, File playerDirectory, String playername) {
        String playernameFiltered = playername.replaceAll(regex, "");
        return new File(playerDirectory, "_" + playernameFiltered + "." + suffix);
    }

    public static void syncItems(EntityPlayer player) {
        int size = 32;
        for (int a = 0; a < size; ++a) {
            UtilPlayerInventoryFilestorage.getPlayerInventory(player).syncSlotToClients(a);
        }
    }

    public static void putDataIntoInventory(InventoryPlayerExtended inventory, EntityPlayer player) {
        inventory.inv = UtilPlayerInventoryFilestorage.getPlayerInventory((EntityPlayer)player).inv;
    }
}

