/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.module.WorldGenModule;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenNetherOre
implements IWorldGenerator {
    private static final int MIN_HEIGHT = 5;
    private static final int MAX_HEIGHT = 128;
    private WorldGenMinable genGold;
    private WorldGenMinable genCoal;
    private WorldGenMinable genEmerald;
    private WorldGenMinable genLapis;
    private WorldGenMinable genDiamond;
    private WorldGenMinable genIron;
    private WorldGenMinable genRedstone;

    public WorldGenNetherOre() {
        if (Configs.blockCountRedstone > 0) {
            this.genRedstone = new WorldGenMinable(WorldGenModule.nether_redstone_ore.func_176223_P(), Configs.blockCountRedstone, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountIron > 0) {
            this.genIron = new WorldGenMinable(WorldGenModule.nether_iron_ore.func_176223_P(), Configs.blockCountIron, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountGold > 0) {
            this.genGold = new WorldGenMinable(WorldGenModule.nether_gold_ore.func_176223_P(), Configs.blockCountGold, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountCoal > 0) {
            this.genCoal = new WorldGenMinable(WorldGenModule.nether_coal_ore.func_176223_P(), Configs.blockCountCoal, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountEmerald > 0) {
            this.genEmerald = new WorldGenMinable(WorldGenModule.nether_emerald_ore.func_176223_P(), Configs.blockCountEmerald, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountLapis > 0) {
            this.genLapis = new WorldGenMinable(WorldGenModule.nether_lapis_ore.func_176223_P(), Configs.blockCountLapis, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
        if (Configs.blockCountDiamond > 0) {
            this.genDiamond = new WorldGenMinable(WorldGenModule.nether_diamond_ore.func_176223_P(), Configs.blockCountDiamond, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == -1) {
            if (this.genRedstone != null && Configs.spawnChanceRedstone > 0) {
                this.run((WorldGenerator)this.genRedstone, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceRedstone, 5, 128);
            }
            if (this.genGold != null && Configs.spawnChanceGold > 0) {
                this.run((WorldGenerator)this.genGold, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceGold, 5, 128);
            }
            if (this.genCoal != null && Configs.spawnChanceCoal > 0) {
                this.run((WorldGenerator)this.genCoal, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceCoal, 5, 128);
            }
            if (this.genEmerald != null && Configs.spawnChanceEmerald > 0) {
                this.run((WorldGenerator)this.genEmerald, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceEmerald, 5, 128);
            }
            if (this.genLapis != null && Configs.spawnChanceLapis > 0) {
                this.run((WorldGenerator)this.genLapis, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceLapis, 5, 128);
            }
            if (this.genDiamond != null && Configs.spawnChanceDiamond > 0) {
                this.run((WorldGenerator)this.genDiamond, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceDiamond, 5, 128);
            }
            if (this.genIron != null && Configs.spawnChanceIron > 0) {
                this.run((WorldGenerator)this.genIron, world, random, chunkX * 16, chunkZ * 16, Configs.spawnChanceIron, 5, 128);
            }
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, pos);
        }
    }

    public static class Configs {
        public static int blockCountCoal = 8;
        public static int blockCountDiamond = 8;
        public static int blockCountEmerald = 8;
        public static int blockCountLapis = 8;
        public static int blockCountGold = 8;
        public static int blockCountIron = 12;
        public static int spawnChanceCoal = 25;
        public static int spawnChanceDiamond = 6;
        public static int spawnChanceEmerald = 5;
        public static int spawnChanceGold = 45;
        public static int spawnChanceLapis = 10;
        public static int spawnChanceIron = 10;
        public static int spawnChanceRedstone = 20;
        public static int blockCountRedstone = 8;
    }
}

