/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.base.CustomEnergyStorage;
import com.lothrazar.cyclic.block.battery.TileBattery;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockBattery
extends BlockBase {
    public BlockBattery(Block.Properties properties) {
        super(properties.func_200943_b(1.8f));
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack battery = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            IEnergyStorage storage = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null) {
                ((CustomEnergyStorage)storage).setEnergy(handlerHere.getEnergyStored());
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), battery));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileBattery();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof INamedContainerProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, result);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            TileBattery container;
            CustomEnergyStorage storageTile;
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null && (storageTile = (CustomEnergyStorage)((Object)(container = (TileBattery)world.func_175625_s(pos)).getCapability(CapabilityEnergy.ENERGY, null).orElse(null))) != null) {
                storageTile.setEnergy(storage.getEnergyStored());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

