/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.capability.EnergyCapabilityItemStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBlockBattery
extends BlockItem {
    public ItemBlockBattery(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xBC000C;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null) {
            TranslationTextComponent t = new TranslationTextComponent(storage.getEnergyStored() + "/" + storage.getMaxEnergyStored(), new Object[0]);
            t.func_211708_a(TextFormatting.RED);
            tooltip.add((ITextComponent)t);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage == null) {
            return 0.0;
        }
        double energy = storage.getEnergyStored();
        return 1.0 - energy / (double)storage.getMaxEnergyStored();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyCapabilityItemStack(stack, 6400000);
    }
}

