/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.base.CustomEnergyStorage;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.battery.ContainerBattery;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBattery
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 6400000;
    private Map<Direction, Boolean> poweredSides;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int flowing = 0;

    public TileBattery() {
        super(CyclicRegistry.Tiles.batterytile);
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(6400000, 1600000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.setFlowing(tag.func_74762_e("flowing"));
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n("flow_" + f.func_176610_l()));
        }
        CompoundNBT energyTag = tag.func_74775_l("energy");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)energyTag));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74757_a("flow_" + f.func_176610_l(), this.poweredSides.get(f).booleanValue());
        }
        tag.func_74768_a("flowing", this.getFlowing());
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBattery(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public void func_73660_a() {
        if (this.getFlowing() == 1) {
            this.tickCableFlow();
        }
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveEnergy(exportToSide, 1600000);
        }
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return -1;
    }

    public static enum Fields {
        FLOWING,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

