/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class UtilEntity {
    private static final double ENTITY_PULL_DIST = 0.4;
    private static final double ENTITY_PULL_SPEED_CUTOFF = 3.0;
    public static final UUID HEALTH_MODIFIER_ID = UUID.fromString("60b1b9b5-dc5d-43a2-aa4e-655353070dbe");
    public static final String HEALTH_MODIFIER_NAME = "Cyclic Health Modifier";
    private static final float ITEMSPEEDFAR = 0.9f;
    private static final float ITEMSPEEDCLOSE = 0.2f;
    static final float lowEnough = 0.001f;
    private static final int TICKS_FALLDIST_SYNC = 16;

    public static void teleportWallSafe(Entity player, World world, double x, double y, double z) {
        BlockPos coords = new BlockPos(x, y, z);
        world.func_217349_x(coords).func_177427_f(true);
        player.func_70634_a(x, y, z);
        UtilEntity.moveEntityWallSafe(player, world);
    }

    public static boolean enderTeleportEvent(LivingEntity player, World world, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(player, x, y, z, 0.0f);
        boolean wasCancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        if (!wasCancelled) {
            UtilEntity.teleportWallSafe(player, world, event.getTargetX(), event.getTargetY(), event.getTargetZ());
        }
        return !wasCancelled;
    }

    public static boolean enderTeleportEvent(LivingEntity player, World world, BlockPos target) {
        return UtilEntity.enderTeleportEvent(player, world, target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
    }

    public static void teleportWallSafe(LivingEntity player, World world, double x, double y, double z) {
        BlockPos coords = new BlockPos(x, y, z);
        world.func_217349_x(coords).func_177427_f(true);
        player.func_70634_a(x, y, z);
        UtilEntity.moveEntityWallSafe((Entity)player, world);
    }

    public static void teleportWallSafe(Entity entityIn, World world, BlockPos coords) {
        UtilEntity.teleportWallSafe(entityIn, world, (double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p());
    }

    public static void moveEntityWallSafe(Entity entity, World world) {
        while (world.func_72829_c(entity.func_174813_aQ())) {
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    public static double getMaxHealth(LivingEntity living) {
        IAttributeInstance healthAttribute = living.func_110148_a(SharedMonsterAttributes.field_111267_a);
        double maxHealth = healthAttribute.func_111125_b();
        AttributeModifier modifier = healthAttribute.func_111127_a(HEALTH_MODIFIER_ID);
        if (modifier != null) {
            maxHealth += modifier.func_111164_d();
        }
        return maxHealth;
    }

    public static Direction getFacing(LivingEntity entity) {
        int yaw = (int)entity.field_70177_z;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 22;
        int facing = (yaw %= 360) / 45;
        return Direction.func_176731_b((int)(facing / 2));
    }

    public static double getSpeedTranslated(double speed) {
        return speed * 100.0;
    }

    public static double getJumpTranslated(double jump) {
        double jumpHeight = 0.0;
        double gravity = 0.98;
        while (jump > 0.0) {
            jumpHeight += jump;
            jump -= 0.08;
            jump *= gravity;
        }
        return jumpHeight;
    }

    public static void launchDirection(Entity entity, float power, Direction facing) {
        double velX = 0.0;
        double velZ = 0.0;
        double velY = 0.0;
        switch (facing) {
            case EAST: {
                velX = Math.abs(power);
                velZ = 0.0;
                break;
            }
            case WEST: {
                velX = -1.0f * Math.abs(power);
                velZ = 0.0;
                break;
            }
            case NORTH: {
                velX = 0.0;
                velZ = -1.0f * Math.abs(power);
                break;
            }
            case SOUTH: {
                velX = 0.0;
                velZ = Math.abs(power);
                break;
            }
        }
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX, velY, velZ);
        } else {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static void launch(Entity entity, float rotationPitch, float power) {
        float rotationYaw = entity.field_70177_z;
        UtilEntity.launch(entity, rotationPitch, rotationYaw, power);
    }

    public static void setVelocity(Entity entity, float rotationPitch, float rotationYaw, float power) {
        entity.func_213293_j(0.0, 0.0, 0.0);
        double velX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (Math.abs(velX) < (double)0.001f) {
            velX = 0.0;
        }
        if (Math.abs(velY) < (double)0.001f) {
            velY = 0.0;
        }
        if (Math.abs(velZ) < (double)0.001f) {
            velZ = 0.0;
        }
        entity.func_70024_g(velX, velY, velZ);
    }

    public static void launch(Entity entity, float rotationPitch, float rotationYaw, float power) {
        Entity ridingEntity;
        float mountPower = (float)((double)power + 0.5);
        double velX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (velY < 0.0) {
            velY *= -1.0;
        }
        if ((ridingEntity = entity.func_184187_bx()) != null) {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX * (double)mountPower, velY * (double)mountPower, velZ * (double)mountPower);
        } else {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static AxisAlignedBB makeBoundingBox(BlockPos center, int hRadius, int vRadius) {
        return new AxisAlignedBB(center).func_72321_a((double)hRadius, (double)vRadius, (double)hRadius);
    }

    public static AxisAlignedBB makeBoundingBox(double x, double y, double z, int hRadius, int vRadius) {
        return new AxisAlignedBB(x - (double)hRadius, y - (double)vRadius, z - (double)hRadius, x + (double)hRadius, y + (double)vRadius, z + (double)hRadius);
    }

    public static int moveEntityItemsInRegion(World world, BlockPos pos, int hRadius, int vRadius) {
        return UtilEntity.moveEntityItemsInRegion(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hRadius, vRadius, true);
    }

    public static int moveEntityItemsInRegion(World world, double x, double y, double z, int hRadius, int vRadius, boolean towardsPos) {
        AxisAlignedBB range = UtilEntity.makeBoundingBox(x, y, z, hRadius, vRadius);
        List<Entity> all = UtilEntity.getItemExp(world, range);
        return UtilEntity.pullEntityList(x, y, z, towardsPos, all);
    }

    public static List<Entity> getItemExp(World world, AxisAlignedBB range) {
        ArrayList<Entity> all = new ArrayList<Entity>();
        all.addAll(world.func_217357_a(ItemEntity.class, range));
        all.addAll(world.func_217357_a(ExperienceOrbEntity.class, range));
        return all;
    }

    public static boolean speedupEntityIfMoving(LivingEntity entity, float factor) {
        if (entity.field_191988_bg > 0.0f) {
            if (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof LivingEntity) {
                UtilEntity.speedupEntity((LivingEntity)entity.func_184187_bx(), factor);
                return true;
            }
            UtilEntity.speedupEntity(entity, factor);
            return true;
        }
        return false;
    }

    public static void speedupEntity(LivingEntity entity, float factor) {
        float x = MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180))) * factor;
        float z = MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * factor;
        entity.func_213293_j((double)x, entity.func_213322_ci().field_72448_b, (double)z);
    }

    public static int moveEntityLivingNonplayers(World world, double x, double y, double z, int ITEM_HRADIUS, int ITEM_VRADIUS, boolean towardsPos, float speed) {
        AxisAlignedBB range = UtilEntity.makeBoundingBox(x, y, z, ITEM_HRADIUS, ITEM_VRADIUS);
        List<LivingEntity> nonPlayer = UtilEntity.getLivingHostile(world, range);
        return UtilEntity.pullEntityList(x, y, z, towardsPos, nonPlayer, speed, speed);
    }

    public static List<LivingEntity> getLivingHostile(World world, AxisAlignedBB range) {
        List all = world.func_217357_a(LivingEntity.class, range);
        ArrayList<LivingEntity> nonPlayer = new ArrayList<LivingEntity>();
        for (LivingEntity ent : all) {
            if (ent instanceof PlayerEntity) continue;
            nonPlayer.add(ent);
        }
        return nonPlayer;
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all) {
        return UtilEntity.pullEntityList(x, y, z, towardsPos, all, 0.2f, 0.9f);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all, float speedClose, float speedFar) {
        int moved = 0;
        int direction = towardsPos ? 1 : -1;
        for (Entity entity : all) {
            double zDist;
            double xDist;
            double hdist;
            if (entity == null || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_70093_af() || !((hdist = Math.sqrt((xDist = Math.abs(x - (double)entity.func_180425_c().func_177958_n())) * xDist + (zDist = Math.abs(z - (double)entity.func_180425_c().func_177952_p())) * zDist)) > 0.4)) continue;
            float speed = hdist > 3.0 ? speedFar : speedClose;
            UtilEntity.setEntityMotionFromVector(entity, x, y, z, (float)direction * speed);
            ++moved;
        }
        return moved;
    }

    public static void setEntityMotionFromVector(Entity entity, double x, double y, double z, float modifier) {
        Vector3 originalPosVector = new Vector3(x, y, z);
        Vector3 entityVector = new Vector3(entity);
        Vector3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        double motionX = finalVector.x * (double)modifier;
        double motionY = finalVector.y * (double)modifier;
        double motionZ = finalVector.z * (double)modifier;
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    public static void addOrMergePotionEffect(LivingEntity player, EffectInstance newp) {
        if (player.func_70644_a(newp.func_188419_a())) {
            EffectInstance p = player.func_70660_b(newp.func_188419_a());
            int ampMax = Math.max(p.func_76458_c(), newp.func_76458_c());
            int dur = newp.func_76459_b() + p.func_76459_b();
            player.func_195064_c(new EffectInstance(newp.func_188419_a(), dur, ampMax));
        } else {
            player.func_195064_c(newp);
        }
    }

    public static void centerEntityHoriz(Entity entity, BlockPos pos) {
        float fixedX = (float)pos.func_177958_n() + 0.5f;
        float fixedZ = (float)pos.func_177952_p() + 0.5f;
        entity.func_70107_b((double)fixedX, entity.field_70163_u, (double)fixedZ);
    }

    public static void tryMakeEntityClimb(World worldIn, LivingEntity entity, double climbSpeed) {
        Vec3d motion = entity.func_213322_ci();
        if (entity.func_70093_af()) {
            entity.func_213293_j(motion.field_72450_a, 0.0, motion.field_72449_c);
        } else if (entity.field_191988_bg > 0.0f && motion.field_72448_b < climbSpeed) {
            entity.func_213293_j(motion.field_72450_a, climbSpeed, motion.field_72449_c);
        }
        if (worldIn.field_72995_K && entity instanceof PlayerEntity && entity.field_70173_aa % 16 == 0) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
    }

    public static List<VillagerEntity> getVillagers(World world, BlockPos p, int r) {
        BlockPos start = p.func_177982_a(-r, -r, -r);
        BlockPos end = p.func_177982_a(r, r, r);
        return world.func_217357_a(VillagerEntity.class, new AxisAlignedBB(start, end));
    }

    public static LivingEntity getClosestEntity(World world, PlayerEntity player, List<? extends LivingEntity> list) {
        LivingEntity closest = null;
        double minDist = 999999.0;
        for (LivingEntity livingEntity : list) {
            double zDistance;
            double xDistance = Math.abs(player.field_70165_t - livingEntity.field_70165_t);
            double dist = Math.sqrt(xDistance * xDistance + (zDistance = Math.abs(player.field_70161_v - livingEntity.field_70161_v)) * zDistance);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = livingEntity;
        }
        return closest;
    }

    public static VillagerEntity getVillager(World world, int x, int y, int z) {
        List all = world.func_217357_a(VillagerEntity.class, new AxisAlignedBB(new BlockPos(x, y, z)));
        if (all.size() == 0) {
            return null;
        }
        return (VillagerEntity)all.get(0);
    }

    public static String getCareerName(VillagerEntity merchant) {
        return merchant.func_145748_c_().func_150254_d();
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static Vec3d lookVector(float rotYaw, float rotPitch) {
        return new Vec3d(Math.sin(rotYaw) * Math.cos(rotPitch), Math.sin(rotPitch), Math.cos(rotYaw) * Math.cos(rotPitch));
    }

    public static float getYawFromFacing(Direction currentFacing) {
        switch (currentFacing) {
            default: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case WEST: 
        }
        return 90.0f;
    }

    public static void setEntityFacing(LivingEntity entity, Direction currentFacing) {
        float yaw = 0.0f;
        switch (currentFacing) {
            case EAST: {
                yaw = 270.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            default: {
                yaw = 0.0f;
            }
        }
        entity.field_70177_z = yaw;
    }

    public static void dragEntityMomentum(LivingEntity entity, double verticalMomentumFactor) {
        double x = entity.func_213322_ci().field_72450_a / verticalMomentumFactor;
        double z = entity.func_213322_ci().field_72449_c / verticalMomentumFactor;
        entity.func_213293_j(x, entity.func_213322_ci().field_72448_b, z);
    }

    private static void setCooldownItemInternal(PlayerEntity player, Item item, int cooldown) {
        player.func_184811_cZ().func_185145_a(item, cooldown);
    }

    public static void setCooldownItem(PlayerEntity player, Item item, int cooldown) {
        if (player.field_70170_p.field_72995_K) {
            UtilEntity.setCooldownItemInternal(player, item, cooldown);
        }
    }
}

