/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class UtilPlaceBlocks {
    public static void rotateBlockValidState(World worldObj, BlockPos pos, Direction side) {
        BlockState clicked = worldObj.func_180495_p(pos);
        if (clicked.func_177230_c() == null) {
            return;
        }
        Block clickedBlock = clicked.func_177230_c();
        BlockState newState = null;
        if (clickedBlock.func_203417_a(BlockTags.field_203292_x)) {
            String key = "type";
            String valueDupe = "double";
            for (IProperty prop : clicked.func_206869_a()) {
                if (!prop.func_177701_a().equals("type") || !(newState = (BlockState)clicked.func_177231_a(prop)).func_177229_b(prop).toString().equals("double")) continue;
                newState = (BlockState)newState.func_177231_a(prop);
            }
        } else {
            switch (side) {
                case DOWN: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case EAST: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case NORTH: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case UP: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case WEST: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
            }
        }
        if (newState != null) {
            worldObj.func_175656_a(pos, newState);
        }
    }

    public static boolean placeStateSafe(World world, @Nullable PlayerEntity player, BlockPos placePos, BlockState placeState) {
        return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState, false);
    }

    public static boolean placeStateSafe(World world, @Nullable PlayerEntity player, BlockPos placePos, BlockState placeState, boolean playSound) {
        if (placePos == null) {
            return false;
        }
        BlockState stateHere = null;
        if (!world.func_175623_d(placePos) && (stateHere = world.func_180495_p(placePos)) != null) {
            Block blockHere = stateHere.func_177230_c();
            if (!stateHere.func_185904_a().func_76224_d()) {
                boolean dropBlock = true;
                if (!world.field_72995_K) {
                    world.func_175655_b(placePos, dropBlock);
                }
            }
        }
        boolean success = false;
        try {
            if (!world.field_72995_K) {
                success = world.func_180501_a(placePos, placeState, 3);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error attempting to place block ", (Throwable)e);
        }
        if (!success || playSound) {
            // empty if block
        }
        return success;
    }
}

