/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic;

import com.lothrazar.cyclicmagic.ModLogger;
import com.lothrazar.cyclicmagic.gui.ModGuiHandler;
import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.proxy.CommonProxy;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.CommandRegistry;
import com.lothrazar.cyclicmagic.registry.DispenserBehaviorRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import com.lothrazar.cyclicmagic.registry.EventRegistry;
import com.lothrazar.cyclicmagic.registry.FuelRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.KeyInventoryShiftRegistry;
import com.lothrazar.cyclicmagic.registry.MobSpawningRegistry;
import com.lothrazar.cyclicmagic.registry.PacketRegistry;
import com.lothrazar.cyclicmagic.registry.PotionRegistry;
import com.lothrazar.cyclicmagic.registry.ProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeAlterRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeNewRegistry;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.registry.StackSizeRegistry;
import com.lothrazar.cyclicmagic.registry.TileEntityRegistry;
import com.lothrazar.cyclicmagic.registry.VillageTradeRegistry;
import com.lothrazar.cyclicmagic.registry.WorldGenRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="cyclicmagic", useMetadata=true, canBeDeactivated=false, updateJSON="https://raw.githubusercontent.com/PrinceOfAmber/CyclicMagic/master/update.json", acceptableRemoteVersions="*", guiFactory="com.lothrazar.cyclicmagic.gui.IngameConfigFactory", acceptedMinecraftVersions="[1.9.4]")
public class ModMain {
    @Mod.Instance(value="cyclicmagic")
    public static ModMain instance;
    @SidedProxy(clientSide="com.lothrazar.cyclicmagic.proxy.ClientProxy", serverSide="com.lothrazar.cyclicmagic.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static ModLogger logger;
    private static Configuration config;
    private EventRegistry events;
    public static SimpleNetworkWrapper network;
    public static final CreativeTabs TAB;
    @CapabilityInject(value=CapabilityRegistry.IPlayerExtendedProperties.class)
    public static final Capability<CapabilityRegistry.IPlayerExtendedProperties> CAPABILITYSTORAGE;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = new ModLogger(event.getModLog());
        config = new Configuration(event.getSuggestedConfigurationFile());
        network = NetworkRegistry.INSTANCE.newSimpleChannel("cyclicmagic");
        MinecraftForge.EVENT_BUS.register((Object)instance);
        this.events = new EventRegistry();
        ItemRegistry.construct();
        BlockRegistry.construct();
        config.load();
        this.syncConfig();
        this.events.register();
        StackSizeRegistry.construct();
        CapabilityRegistry.register();
        ReflectionRegistry.register();
        PacketRegistry.register(network);
        SoundRegistry.register();
        EnchantRegistry.register();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        PotionRegistry.register();
        ItemRegistry.register();
        BlockRegistry.register();
        SpellRegistry.register();
        MobSpawningRegistry.register();
        WorldGenRegistry.register();
        FuelRegistry.register();
        StackSizeRegistry.register();
        RecipeAlterRegistry.register();
        RecipeNewRegistry.register();
        VillageTradeRegistry.register();
        proxy.register();
        TileEntityRegistry.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ModGuiHandler());
        ProjectileRegistry.register(event);
        MinecraftForge.EVENT_BUS.register((Object)BlockRegistry.block_storeempty);
        MinecraftForge.EVENT_BUS.register((Object)ItemRegistry.corrupted_chorus);
        MinecraftForge.EVENT_BUS.register((Object)ItemRegistry.heart_food);
        MinecraftForge.EVENT_BUS.register((Object)ItemRegistry.tool_push);
        MinecraftForge.EVENT_BUS.register((Object)EnchantRegistry.launch);
        MinecraftForge.EVENT_BUS.register((Object)EnchantRegistry.magnet);
        MinecraftForge.EVENT_BUS.register((Object)EnchantRegistry.venom);
        MinecraftForge.EVENT_BUS.register((Object)PotionRegistry.slowfall);
        MinecraftForge.EVENT_BUS.register((Object)PotionRegistry.magnet);
        MinecraftForge.EVENT_BUS.register((Object)PotionRegistry.waterwalk);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        DispenserBehaviorRegistry.register();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandRegistry.register(event);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("cyclicmagic")) {
            instance.syncConfig();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public void syncConfig() {
        Configuration c = ModMain.getConfig();
        EnchantRegistry.syncConfig(c);
        WorldGenRegistry.syncConfig(c);
        PotionRegistry.syncConfig(c);
        this.events.syncConfig(c);
        BlockRegistry.syncConfig(c);
        ItemRegistry.syncConfig(c);
        FuelRegistry.syncConfig(c);
        MobSpawningRegistry.syncConfig(c);
        RecipeAlterRegistry.syncConfig(c);
        RecipeNewRegistry.syncConfig(c);
        DispenserBehaviorRegistry.syncConfig(c);
        StackSizeRegistry.syncConfig(c);
        SpellRegistry.syncConfig(c);
        CommandRegistry.syncConfig(c);
        VillageTradeRegistry.syncConfig(c);
        KeyInventoryShiftRegistry.syncConfig(c);
        c.save();
    }

    static {
        TAB = new CreativeTabs("cyclicmagic"){

            public Item func_78016_d() {
                ItemCyclicWand tab = ItemRegistry.cyclic_wand_build;
                if (tab == null) {
                    tab = Items.field_151045_i;
                }
                return tab;
            }
        };
        CAPABILITYSTORAGE = null;
    }
}

