/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityUncrafting;
import com.lothrazar.cyclicmagic.util.UtilUncraft;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockUncrafting
extends Block
implements IHasRecipe,
IHasConfig {
    private static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockUncrafting() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149675_a(true);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        player.openGui((Object)ModMain.instance, 0, world, x, y, z);
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos, state);
        super.func_180663_b(world, pos, state);
    }

    private void dropItems(World world, BlockPos pos, IBlockState state) {
        Random rand = world.field_73012_v;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IInventory)) {
            return;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IInventory inventory = (IInventory)tile;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77952_i()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float f = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)f;
            entityItem.field_70181_x = rand.nextGaussian() * (double)f + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)f;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityUncrafting();
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.func_149716_u();
    }

    @Override
    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this), (Object[])new Object[]{" r ", "fdf", " o ", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Blocks.field_150409_cd, Character.valueOf('d'), Blocks.field_150484_ah});
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "modpacks.SaplingGrowthDetail";
        UtilUncraft.dictionaryFreedom = config.getBoolean("PickFirstMeta", category, true, "If you change this to true, then the uncrafting will just take the first of many options in any recipe that takes multiple input types.  For example, false means chests cannot be uncrafted, but true means chests will ALWAYS give oak wooden planks.");
        config.addCustomCategoryComment(category, "Here you can blacklist any thing, vanilla or modded.  Mostly for creating modpacks.  Input means you cannot uncraft it at all.  Output means it will not come out of a recipe.");
        String def = "";
        String csv = config.getString("BlacklistInput", category, def, "Items that cannot be uncrafted; not allowed in the slots.  EXAMPLE : 'item.stick,tile.hayBlock,tile.chest'  ");
        UtilUncraft.blacklistInput = Arrays.asList(csv.split(","));
        if (UtilUncraft.blacklistInput == null) {
            UtilUncraft.blacklistInput = new ArrayList<String>();
        }
        if ((UtilUncraft.blacklistOutput = Arrays.asList((csv = config.getString("BlacklistOutput", category, def = "item.milk", "Comma seperated items that cannot come out of crafting recipes.  For example, if milk is in here, then cake is uncrafted you get all items except the milk buckets.  ")).split(","))) == null) {
            UtilUncraft.blacklistOutput = new ArrayList<String>();
        }
    }
}

