/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.BlockBuilder;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class TileEntityBuilder
extends TileEntity
implements IInventory,
ITickable,
ISidedInventory {
    private int timer;
    private int buildType;
    private int buildSpeed;
    private int buildSize;
    private int buildHeight = 3;
    private ItemStack[] inv = new ItemStack[9];
    private int shapeIndex = 0;
    private List<BlockPos> shape = null;
    private BlockPos nextPos;
    private static final int maxSpeed = 1;
    public static int maxSize;
    public static int maxHeight;
    public static final int TIMER_FULL = 100;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_NEXTPOS = "Pos";
    private static final String NBT_BUILDTYPE = "build";
    private static final String NBT_SHAPE = "shape";
    private static final String NBT_SPEED = "speed";
    private static final String NBT_SIZE = "size";
    private static final String NBT_SHAPEINDEX = "shapeindex";

    public void rebuildShape() {
        BuildType buildType = this.getBuildTypeEnum();
        switch (buildType) {
            case CIRCLE: {
                this.shape = UtilPlaceBlocks.circle(this.field_174879_c, this.getSize() * 2);
                break;
            }
            case FACING: {
                this.shape = UtilPlaceBlocks.line(this.field_174879_c, this.getCurrentFacing().func_176734_d(), this.getSize());
                break;
            }
            case SQUARE: {
                this.shape = UtilPlaceBlocks.squareHorizontalHollow(this.field_174879_c, this.getSize());
                break;
            }
        }
        if (this.buildHeight > 1) {
            this.shape = UtilPlaceBlocks.repeatShapeByHeight(this.shape, this.buildHeight - 1);
        }
        this.shapeIndex = 0;
        if (this.shape.size() > 0) {
            this.nextPos = this.shape.get(this.shapeIndex);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case BUILDTYPE: {
                    return this.buildType;
                }
                case SPEED: {
                    return this.buildSpeed;
                }
                case SIZE: {
                    return this.buildSize;
                }
                case HEIGHT: {
                    return this.buildHeight;
                }
            }
        }
        return -1;
    }

    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case BUILDTYPE: {
                    this.buildType = value;
                    break;
                }
                case SPEED: {
                    this.buildSpeed = value;
                    break;
                }
                case SIZE: {
                    this.buildSize = value;
                    break;
                }
                case HEIGHT: {
                    this.buildHeight = value;
                    break;
                }
            }
        }
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    public int getHeight() {
        return this.func_174887_a_(Fields.HEIGHT.ordinal());
    }

    public void setHeight(int value) {
        this.func_174885_b(Fields.HEIGHT.ordinal(), value);
    }

    public int getBuildType() {
        return this.func_174887_a_(Fields.BUILDTYPE.ordinal());
    }

    public void setBuildType(int value) {
        this.func_174885_b(Fields.BUILDTYPE.ordinal(), value);
    }

    public BuildType getBuildTypeEnum() {
        int bt = Math.min(this.getBuildType(), BuildType.values().length - 1);
        return BuildType.values()[bt];
    }

    public void setSpeed(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= 1) {
            s = 1;
        }
        this.func_174885_b(Fields.SPEED.ordinal(), s);
    }

    public int getSpeed() {
        int s = this.func_174887_a_(Fields.SPEED.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    public void setSize(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= maxSize) {
            s = maxSize;
        }
        this.func_174885_b(Fields.SIZE.ordinal(), s);
    }

    public int getSize() {
        int s = this.func_174887_a_(Fields.SIZE.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    public int func_174890_g() {
        return Fields.values().length;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = null;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        this.shapeIndex = tagCompound.func_74762_e(NBT_SHAPEINDEX);
        this.nextPos = UtilNBT.stringCSVToBlockPos(tagCompound.func_74779_i(NBT_NEXTPOS));
        if (this.nextPos == null || this.nextPos.func_177958_n() == 0 && this.nextPos.func_177956_o() == 0 && this.nextPos.func_177952_p() == 0) {
            this.nextPos = this.field_174879_c;
        }
        this.shape = new ArrayList<BlockPos>();
        NBTTagList sh = tagCompound.func_150295_c(NBT_SHAPE, 10);
        for (int i = 0; i < sh.func_74745_c(); ++i) {
            NBTTagCompound tag = sh.func_150305_b(i);
            BlockPos pos = UtilNBT.stringCSVToBlockPos(tag.func_74779_i("shapepos"));
            this.shape.add(pos);
        }
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.buildType = tagCompound.func_74762_e(NBT_BUILDTYPE);
        this.buildSpeed = tagCompound.func_74762_e(NBT_SPEED);
        this.buildSize = tagCompound.func_74762_e(NBT_SIZE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        tagCompound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        if (this.nextPos == null || this.nextPos.func_177958_n() == 0 && this.nextPos.func_177956_o() == 0 && this.nextPos.func_177952_p() == 0) {
            this.nextPos = this.field_174879_c;
        }
        tagCompound.func_74778_a(NBT_NEXTPOS, UtilNBT.posToStringCSV(this.nextPos));
        NBTTagList sh = new NBTTagList();
        if (this.shape == null) {
            this.shape = new ArrayList<BlockPos>();
        }
        for (BlockPos p : this.shape) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("shapepos", UtilNBT.posToStringCSV(p));
            sh.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_SHAPE, (NBTBase)sh);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        tagCompound.func_74768_a(NBT_BUILDTYPE, this.getBuildType());
        tagCompound.func_74768_a(NBT_SPEED, this.getSpeed());
        tagCompound.func_74768_a(NBT_SIZE, this.getSize());
        return super.func_189515_b(tagCompound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public BlockPos getNextPos() {
        return this.nextPos;
    }

    private void shiftAllUp() {
        for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
            this.shiftPairUp(i, i + 1);
        }
    }

    private void shiftPairUp(int low, int high) {
        ItemStack main = this.func_70301_a(low);
        ItemStack second = this.func_70301_a(high);
        if (main == null && second != null) {
            this.func_70299_a(high, null);
            this.func_70299_a(low, second);
        }
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < 100;
    }

    public void func_73660_a() {
        this.shiftAllUp();
        boolean trigger = false;
        if (this.nextPos == null || this.nextPos.func_177958_n() == 0 && this.nextPos.func_177956_o() == 0 && this.nextPos.func_177952_p() == 0) {
            this.nextPos = this.field_174879_c;
        }
        if (this.field_145850_b.func_175676_y(this.func_174877_v()) == 0) {
            this.func_70296_d();
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.nextPos != null && this.field_145850_b.field_73012_v.nextDouble() < 0.1 && this.inv[0] != null) {
            UtilParticle.spawnParticlePacket(EnumParticleTypes.DRAGON_BREATH, this.nextPos, 5);
        }
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            this.timer = 100;
        } else {
            this.timer -= this.getSpeed();
            if (this.timer <= 0) {
                this.timer = 100;
                trigger = true;
            }
        }
        if (trigger) {
            Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
            if (stuff != null) {
                if (!this.field_145850_b.field_72995_K && UtilPlaceBlocks.placeStateSafe(this.field_145850_b, null, this.nextPos, stuff.func_176203_a(stack.func_77960_j()))) {
                    this.func_70298_a(0, 1);
                }
                this.incrementPosition();
            }
        } else if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
            UtilParticle.spawnParticle(this.field_145850_b, EnumParticleTypes.SMOKE_NORMAL, x, y, z);
        }
        this.func_70296_d();
    }

    private EnumFacing getCurrentFacing() {
        BlockBuilder b = (BlockBuilder)this.field_145854_h;
        EnumFacing facing = b == null || this.field_145850_b.func_180495_p(this.field_174879_c) == null || b.getFacingFromState(this.field_145850_b.func_180495_p(this.field_174879_c)) == null ? EnumFacing.UP : b.getFacingFromState(this.field_145850_b.func_180495_p(this.field_174879_c));
        return facing;
    }

    private void incrementPosition() {
        if (this.nextPos == null) {
            this.nextPos = this.field_174879_c;
        }
        if (this.field_145850_b == null) {
            return;
        }
        if (this.shape == null || this.shape.size() == 0) {
            this.rebuildShape();
        } else {
            int c = this.shapeIndex + 1;
            if (c < 0 || c >= this.shape.size()) {
                c = 0;
            }
            this.nextPos = this.shape.get(c);
            this.shapeIndex = c;
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.hopperInput;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    static {
        maxHeight = 10;
    }

    public static enum BuildType {
        FACING,
        SQUARE,
        CIRCLE;


        public static BuildType getNextType(BuildType btype) {
            int type = btype.ordinal();
            if (++type > CIRCLE.ordinal()) {
                type = FACING.ordinal();
            }
            return BuildType.values()[type];
        }
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SPEED,
        SIZE,
        HEIGHT;

    }
}

