/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.BlockUncrafting;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilUncraft;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class TileEntityUncrafting
extends TileEntity
implements IInventory,
ITickable,
ISidedInventory {
    public static final int TIMER_FULL = 200;
    private ItemStack[] inv;
    private int timer = 200;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_TIMER = "Timer";

    public TileEntityUncrafting() {
        this.inv = new ItemStack[9];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public int getTimer() {
        return this.timer;
    }

    private void shiftAllUp() {
        for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
            this.shiftPairUp(i, i + 1);
        }
    }

    private void shiftPairUp(int low, int high) {
        ItemStack main = this.func_70301_a(low);
        ItemStack second = this.func_70301_a(high);
        if (main == null && second != null) {
            this.func_70299_a(high, null);
            this.func_70299_a(low, second);
        }
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < 200;
    }

    public void func_73660_a() {
        this.shiftAllUp();
        boolean triggerUncraft = false;
        if (this.field_145850_b.func_175676_y(this.func_174877_v()) == 0) {
            return;
        }
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            this.timer = 200;
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 200;
            triggerUncraft = true;
        }
        if (triggerUncraft) {
            UtilUncraft uncrafter;
            EnumFacing facing = null;
            facing = (BlockUncrafting)this.field_145854_h == null || this.field_145850_b.func_180495_p(this.field_174879_c) == null || ((BlockUncrafting)this.field_145854_h).getFacingFromState(this.field_145850_b.func_180495_p(this.field_174879_c)) == null ? EnumFacing.UP : ((BlockUncrafting)this.field_145854_h).getFacingFromState(this.field_145850_b.func_180495_p(this.field_174879_c));
            int dx = 0;
            int dz = 0;
            if (facing == EnumFacing.SOUTH) {
                dz = -1;
            } else if (facing == EnumFacing.NORTH) {
                dz = 1;
            } else if (facing == EnumFacing.EAST) {
                dx = -1;
            } else if (facing == EnumFacing.WEST) {
                dx = 1;
            }
            BlockPos posOffsetFacing = new BlockPos(x += (double)dx, y, z += (double)dz);
            TileEntity attached = this.field_145850_b.func_175625_s(posOffsetFacing);
            IInventory attachedInv = null;
            if (attached != null && attached instanceof IInventory) {
                attachedInv = (IInventory)attached;
            }
            if ((uncrafter = new UtilUncraft(stack)).doUncraft()) {
                if (!this.field_145850_b.field_72995_K) {
                    ArrayList<ItemStack> uncrafterOutput = uncrafter.getDrops();
                    ArrayList<Object> toDrop = new ArrayList();
                    toDrop = attached != null ? TileEntityUncrafting.dumpToIInventory(uncrafterOutput, attachedInv) : uncrafterOutput;
                    for (ItemStack s : toDrop) {
                        UtilEntity.dropItemStackInWorld(this.field_145850_b, posOffsetFacing, s);
                    }
                    this.func_70298_a(0, uncrafter.getOutsize());
                }
                UtilSound.playSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS);
            } else {
                if (attached != null) {
                    ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                    toDrop.add(stack);
                    toDrop = TileEntityUncrafting.dumpToIInventory(toDrop, attachedInv);
                    if (toDrop.size() == 1) {
                        UtilEntity.dropItemStackInWorld(this.field_145850_b, posOffsetFacing, toDrop.get(0));
                    }
                } else {
                    UtilEntity.dropItemStackInWorld(this.field_145850_b, posOffsetFacing, stack);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.func_70298_a(0, stack.field_77994_a);
                }
                UtilSound.playSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187737_v, SoundCategory.BLOCKS);
            }
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v().func_177984_a());
            this.func_70296_d();
        } else if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
            UtilParticle.spawnParticle(this.field_145850_b, EnumParticleTypes.SMOKE_NORMAL, x, y, z);
        }
    }

    public static ArrayList<ItemStack> dumpToIInventory(ArrayList<ItemStack> stacks, IInventory inventory) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack current : stacks) {
            if (current == null) continue;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int space;
                int toDeposit;
                if (current == null) continue;
                ItemStack chestStack = inventory.func_70301_a(i);
                if (chestStack == null) {
                    inventory.func_70299_a(i, current);
                    current = null;
                    continue;
                }
                if (!chestStack.func_77969_a(current) || (toDeposit = Math.min(space = chestStack.func_77976_d() - chestStack.field_77994_a, current.field_77994_a)) <= 0) continue;
                current.field_77994_a -= toDeposit;
                chestStack.field_77994_a += toDeposit;
                if (current.field_77994_a != 0) continue;
                current = null;
            }
            if (current == null) continue;
            remaining.add(current);
        }
        return remaining;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.hopperInput;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public String func_70005_c_() {
        return null;
    }
}

