/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import com.lothrazar.cyclicmagic.command.BaseCommand;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSearchWorld;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandSearchItem
extends BaseCommand
implements ICommand {
    public static final String name = "searchitem";

    public CommandSearchItem(boolean op) {
        super(name, op);
    }

    @Override
    public String func_71518_a(ICommandSender arg0) {
        return "/" + this.func_71517_b() + " <itemname> [radius]";
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        IInventory tile;
        World world = sender.func_130014_f_();
        if (args.length < 1) {
            UtilChat.addChatMessage(sender, this.func_71518_a(sender));
            return;
        }
        int radius = 0;
        if (args.length > 1) {
            radius = Integer.parseInt(args[1]);
        }
        if (radius > 128) {
            radius = 128;
        }
        if (radius <= 0) {
            radius = 64;
        }
        String searchQuery = args[0].trim().toLowerCase();
        ArrayList<IInventory> tilesToSearch = new ArrayList<IInventory>();
        HashMap<IInventory, BlockPos> dictionary = new HashMap<IInventory, BlockPos>();
        ArrayList<BlockPos> foundChests = UtilSearchWorld.findBlocks(world, sender.func_180425_c(), (Block)Blocks.field_150486_ae, radius);
        for (BlockPos blockPos : foundChests) {
            tile = (IInventory)world.func_175625_s(blockPos);
            tilesToSearch.add(tile);
            dictionary.put(tile, blockPos);
        }
        ArrayList<BlockPos> foundTrapChests = UtilSearchWorld.findBlocks(world, sender.func_180425_c(), Blocks.field_150447_bR, radius);
        for (BlockPos blockPos : foundTrapChests) {
            tile = (IInventory)world.func_175625_s(blockPos);
            tilesToSearch.add(tile);
            dictionary.put(tile, blockPos);
        }
        ArrayList<BlockPos> arrayList = UtilSearchWorld.findBlocks(sender.func_130014_f_(), sender.func_180425_c(), Blocks.field_150367_z, radius);
        for (BlockPos pos : arrayList) {
            tile = (IInventory)world.func_175625_s(pos);
            tilesToSearch.add(tile);
            dictionary.put(tile, pos);
        }
        ArrayList<String> foundMessages = new ArrayList<String>();
        for (IInventory inventory : tilesToSearch) {
            boolean bl = false;
            int n = UtilSearchWorld.searchTileInventory(searchQuery, inventory);
            if (n <= 0) continue;
            String totalsStr = n + " : ";
            foundMessages.add(totalsStr + CommandSearchItem.getCoordsOrReduced((BlockPos)dictionary.get(inventory)));
        }
        int ifound = foundMessages.size();
        if (ifound == 0) {
            UtilChat.addChatMessage(sender, UtilChat.lang("command.searchitem.none") + " : " + radius);
        } else {
            for (int i = 0; i < ifound; ++i) {
                UtilChat.addChatMessage(sender, (String)foundMessages.get(i));
            }
        }
    }

    public static String getCoordsOrReduced(BlockPos pos) {
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }
}

