/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import com.lothrazar.cyclicmagic.command.BaseCommand;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class CommandSearchTrades
extends BaseCommand
implements ICommand {
    public static final String name = "searchtrade";

    public CommandSearchTrades(boolean op) {
        super(name, op);
    }

    @Override
    public String func_71518_a(ICommandSender ic) {
        return "/" + this.func_71517_b() + " <item name> <qty>";
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender ic, String[] args) {
        if (!(ic instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)ic;
        if (args.length == 0) {
            UtilChat.addChatMessage(p, this.func_71518_a(ic));
            return;
        }
        String searching = args[0].toLowerCase();
        int searchingQty = -1;
        if (args.length > 1 && (searchingQty = Integer.parseInt(args[1])) < 0) {
            searchingQty = 0;
        }
        double X = ic.func_180425_c().func_177958_n();
        double Z = ic.func_180425_c().func_177952_p();
        double range = 64.0;
        AxisAlignedBB searchRange = new AxisAlignedBB(X + 0.5 - range, 0.0, Z + 0.5 - range, X + 0.5 + range, 255.0, Z + 0.5 + range);
        List merchants = ic.func_130014_f_().func_72872_a(EntityVillager.class, searchRange);
        ArrayList<EntityVillager> villagers = new ArrayList<EntityVillager>();
        for (EntityVillager m : merchants) {
            if (m.func_70631_g_()) continue;
            villagers.add(m);
        }
        ArrayList<String> messages = new ArrayList<String>();
        boolean match = false;
        for (int i = 0; i < villagers.size(); ++i) {
            EntityLiving v_entity = (EntityLiving)villagers.get(i);
            IMerchant v_merch = (IMerchant)villagers.get(i);
            MerchantRecipeList list = v_merch.func_70934_b(p);
            for (int r = 0; r < list.size(); ++r) {
                match = false;
                MerchantRecipe rec = (MerchantRecipe)list.get(r);
                String disabled = rec.func_82784_g() ? "[x] " : "";
                ItemStack buy = rec.func_77394_a();
                ItemStack buySecond = rec.func_77396_b();
                ItemStack sell = rec.func_77397_d();
                if (buy.func_82833_r().toLowerCase().contains(searching) && (searchingQty < 0 || searchingQty == buy.field_77994_a)) {
                    match = true;
                }
                if (buySecond != null && buySecond.func_82833_r().contains(searching) && (searchingQty < 0 || searchingQty == buySecond.field_77994_a)) {
                    match = true;
                }
                if (sell.func_82833_r().contains(searching) && (searchingQty < 0 || searchingQty == sell.field_77994_a)) {
                    match = true;
                }
                if (!match) continue;
                String m = disabled + UtilChat.blockPosToString(v_entity.func_180425_c()) + " " + sell.field_77994_a + " " + sell.func_82833_r() + " :: " + buy.field_77994_a + " " + buy.func_82833_r();
                messages.add(m);
            }
        }
        for (int j = 0; j < messages.size(); ++j) {
            UtilChat.addChatMessage(p, (String)messages.get(j));
        }
        if (messages.size() == 0) {
            UtilChat.addChatMessage(p, UtilChat.lang("command.searchtrade.none") + " [" + range + "]");
        }
    }
}

