/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class Location {
    public double X;
    public double Y;
    public double Z;
    public int index;
    public int dimension = 0;
    public String name;

    public Location(BlockPos pos) {
        this.X = pos.func_177958_n();
        this.Y = pos.func_177956_o();
        this.Z = pos.func_177952_p();
        this.index = 0;
        this.dimension = 0;
        this.name = "";
    }

    public Location(BlockPos pos, int dim, int idx, String pname) {
        this.X = pos.func_177958_n();
        this.Y = pos.func_177956_o();
        this.Z = pos.func_177952_p();
        this.index = idx;
        this.dimension = dim;
        this.name = pname;
    }

    public Location(int idx, double pX, double pY, double pZ, int d, String pname) {
        this.X = pX;
        this.Y = pY;
        this.Z = pZ;
        this.index = idx;
        this.dimension = d;
        this.name = pname;
        if (this.name == null) {
            this.name = "";
        }
    }

    public Location(int idx, EntityPlayer p, String pname) {
        this.X = p.field_70165_t;
        this.Y = p.field_70163_u;
        this.Z = p.field_70161_v;
        this.index = idx;
        this.dimension = p.field_71093_bK;
        this.name = pname;
        if (this.name == null) {
            this.name = "";
        }
    }

    public Location(String csv) {
        String[] pts = csv.split(",");
        this.X = Double.parseDouble(pts[0]);
        this.Y = Double.parseDouble(pts[1]);
        this.Z = Double.parseDouble(pts[2]);
        this.dimension = Integer.parseInt(pts[3]);
        if (pts.length > 4) {
            this.name = pts[4];
        }
        if (this.name == null) {
            this.name = "";
        }
    }

    public String toCSV() {
        if (this.name == null) {
            this.name = "";
        }
        return this.X + "," + this.Y + "," + this.Z + "," + this.dimension + "," + this.name;
    }

    public String toDisplay() {
        if (this.name == null) {
            this.name = "";
        }
        String showName = " ";
        if (this.name != null && !this.name.isEmpty()) {
            showName = "  :  " + this.name;
        }
        return Math.round(this.X) + ", " + Math.round(this.Y) + ", " + Math.round(this.Z) + showName;
    }

    public String toDisplayShort() {
        if (this.name == null) {
            this.name = "";
        }
        String showName = " ";
        if (this.name != null && !this.name.isEmpty()) {
            showName = "  :  " + this.name;
        }
        return showName + Math.round(this.X) + ", " + Math.round(this.Y) + ", " + Math.round(this.Z);
    }

    public String toDisplayNoCoords() {
        return this.name + " (y = " + MathHelper.func_76128_c((double)this.Y) + ")";
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }
}

