/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventFurnaceStardew
implements IHasConfig {
    private static boolean stardewFurnace;
    static final int SLOT_INPUT = 0;
    static final int SLOT_FUEL = 1;
    static final int SLOT_OUTPUT = 2;

    @SubscribeEvent
    public void onPlayerFurnace(PlayerInteractEvent event) {
        TileEntity tile;
        if (!stardewFurnace) {
            return;
        }
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        BlockPos pos = event.getPos();
        World worldObj = event.getWorld();
        if (pos == null) {
            return;
        }
        ItemStack held = entityPlayer.func_184586_b(event.getHand());
        int playerSlot = entityPlayer.field_71071_by.field_70461_c;
        if (held == null) {
            held = entityPlayer.func_184592_cb();
            playerSlot = entityPlayer.field_71071_by.func_70302_i_() - 1;
        }
        if ((tile = worldObj.func_175625_s(pos)) instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)tile;
            if (held == null) {
                this.extractFurnaceOutput(furnace);
            } else if (this.isFuel(held)) {
                this.tryMergeStackIntoSlot(furnace, entityPlayer, playerSlot, 1);
            } else if (this.canBeSmelted(held)) {
                this.tryMergeStackIntoSlot(furnace, entityPlayer, playerSlot, 0);
            }
        }
    }

    private void tryMergeStackIntoSlot(TileEntityFurnace furnace, EntityPlayer entityPlayer, int playerSlot, int furnaceSlot) {
        ItemStack current = furnace.func_70301_a(furnaceSlot);
        ItemStack held = entityPlayer.field_71071_by.func_70304_b(playerSlot);
        if (current == null) {
            furnace.func_70299_a(furnaceSlot, held.func_77946_l());
            held = null;
            entityPlayer.field_71071_by.func_70299_a(playerSlot, null);
        } else {
            UtilInventory.mergeItemsBetweenStacks(held, current);
            if (held.field_77994_a == 0) {
                held = null;
            }
            entityPlayer.field_71071_by.func_70299_a(playerSlot, held);
        }
        entityPlayer.field_71071_by.func_70296_d();
    }

    private void extractFurnaceOutput(TileEntityFurnace furnace) {
        ItemStack current = furnace.func_70304_b(2);
        if (current != null) {
            UtilEntity.dropItemStackInWorld(furnace.func_145831_w(), furnace.func_174877_v(), current);
        }
    }

    private boolean canBeSmelted(ItemStack input) {
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(input);
        return itemstack != null;
    }

    private boolean isFuel(ItemStack input) {
        return TileEntityFurnace.func_145952_a((ItemStack)input) > 0;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.player";
        stardewFurnace = config.getBoolean("Furnace Speed", category, true, "Quickly fill a furnace by hitting it with fuel or an item, or interact with an empty hand to pull out the results [Inspired by Stardew Valley]");
    }
}

