/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.gui.button.ButtonTerrariaDepositAll;
import com.lothrazar.cyclicmagic.gui.button.ButtonTerrariaLootAll;
import com.lothrazar.cyclicmagic.gui.button.ButtonTerrariaQuickStack;
import com.lothrazar.cyclicmagic.gui.button.ButtonTerrariaRestock;
import com.lothrazar.cyclicmagic.gui.player.GuiPlayerExtended;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventGuiTerrariaButtons
implements IHasConfig {
    private String position;
    public static boolean restockLeaveOne;
    public static final String posLeft = "topleft";
    public static final String posRight = "topright";
    public static final String posBottom = "bottomleft";
    public static final String posAlign = "align";
    public static final int padding = 4;
    public static final int BTNWIDTH = 20;
    private List<String> blacklistGuis;
    private boolean isEnabled;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!this.isEnabled) {
            return;
        }
        GuiScreen gui = event.getGui();
        if (gui == null) {
            return;
        }
        String self = gui.getClass().getName();
        int button_id = 256;
        int x = 0;
        int y = 0;
        int yDelta = 24;
        int xDelta = 0;
        if (gui instanceof GuiContainer && !(gui instanceof GuiInventory) && !(gui instanceof GuiPlayerExtended) && !this.blacklistGuis.contains(self)) {
            GuiContainer guiInv = (GuiContainer)gui;
            if (this.position.equalsIgnoreCase(posLeft)) {
                x = 4;
                y = 4;
                xDelta = 0;
                yDelta = 24;
            } else if (this.position.equalsIgnoreCase(posRight)) {
                x = Minecraft.func_71410_x().field_71443_c / 2 - 20 - 4;
                y = 4;
                xDelta = 0;
                yDelta = 24;
            } else if (this.position.equalsIgnoreCase(posBottom)) {
                x = 4;
                y = Minecraft.func_71410_x().field_71440_d / 2 - 4 - 20;
                xDelta = 24;
                yDelta = 0;
            } else {
                if (!this.position.equalsIgnoreCase(posAlign)) {
                    // empty if block
                }
                int guiLeft = (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiInv, (String[])new String[]{"i", "field_147003_i", "guiLeft"});
                int guiTop = (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiInv, (String[])new String[]{"r", "field_147009_r", "guiTop"});
                x = guiLeft;
                y = guiTop;
                xDelta = 0;
                yDelta = 24;
            }
            event.getButtonList().add(new ButtonTerrariaLootAll(button_id++, x, y));
            event.getButtonList().add(new ButtonTerrariaDepositAll(button_id++, x += xDelta, y += yDelta));
            event.getButtonList().add(new ButtonTerrariaQuickStack(button_id++, x += xDelta, y += yDelta));
            event.getButtonList().add(new ButtonTerrariaRestock(button_id++, x += xDelta, y += yDelta));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.Inventory";
        config.setCategoryComment(category, "Terraria-inspired inventory helper buttons");
        this.isEnabled = config.getBoolean("TerrariaInventoryButtons", category, true, "Adds extra buttons to containers to quickly move items between your inventory (Inspired by terraria)");
        ArrayList<String> valid = new ArrayList<String>();
        valid.add(posLeft);
        valid.add(posRight);
        valid.add(posBottom);
        restockLeaveOne = config.getBoolean("Restock Leave One", category, false, "By default (false) the Restock feature will empty your chests if possible.  If you change this to true, then using Restock will leave one behind of each item stack");
        this.position = config.getString("Button Location", category, posBottom, "Location of the extra inventory buttons, valid entries are: " + String.join((CharSequence)",", valid));
        if (!valid.contains(this.position)) {
            this.position = posRight;
        }
        category = "modpacks.TerrariaButtons";
        config.addCustomCategoryComment(category, "Here you can blacklist any container, vanilla or modded. Mostly for creating modpacks, if some containers shouldnt have these buttons showing up.");
        String blacklistDefault = "net.minecraft.client.gui.GuiMerchant,net.minecraft.client.gui.inventory.GuiBrewingStand,net.minecraft.client.gui.inventory.GuiBeacon,net.minecraft.client.gui.inventory.GuiCrafting,net.minecraft.client.gui.inventory.GuiFurnace,net.minecraft.client.gui.inventory.GuiScreenHorseInventory,net.minecraft.client.gui.inventory.GuiContainerCreative";
        String csv = config.getString("Blacklist Container CSV", category, blacklistDefault, "FOR MODPACK DEVS: These containers are blocked from getting the buttons.  By default, anything that extends 'GuiContainer' will get the buttons.  ");
        this.blacklistGuis = Arrays.asList(csv.split(","));
        if (this.blacklistGuis == null) {
            this.blacklistGuis = new ArrayList<String>();
        }
    }
}

