/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventMobDropBuffs
implements IHasConfig {
    public static boolean sheepShearBuffed;
    private boolean zombieVillagerEmeralds;
    private boolean extraLeather;
    private boolean bonusPork;
    private boolean bonusGolemIron;
    private final int chanceZombieVillagerEmerald = 25;

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (sheepShearBuffed && event.getEntityPlayer() != null && event.getTarget() instanceof EntitySheep) {
            EntityPlayer p = event.getEntityPlayer();
            EntitySheep s = (EntitySheep)event.getTarget();
            if (event.getHand() != null && p.func_184586_b(event.getHand()) != null && p.func_184586_b(event.getHand()).func_77973_b() == Items.field_151097_aZ) {
                int meta = s.func_175509_cj().func_176765_a();
                int rand = MathHelper.func_76136_a((Random)event.getWorld().field_73012_v, (int)1, (int)6);
                UtilEntity.dropItemStackInWorld(event.getWorld(), event.getPos(), new ItemStack(Blocks.field_150325_L, rand, meta));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        EntityZombie z;
        Entity entity = event.getEntity();
        World worldObj = entity.func_130014_f_();
        List drops = event.getDrops();
        BlockPos pos = entity.func_180425_c();
        if (entity instanceof EntityZombie && this.zombieVillagerEmeralds && (z = (EntityZombie)entity).func_82231_m() && worldObj.field_73012_v.nextInt(100) <= 25) {
            drops.add(new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Items.field_151166_bC)));
        }
        if (this.extraLeather && entity instanceof EntityCow) {
            int rand = MathHelper.func_76136_a((Random)worldObj.field_73012_v, (int)1, (int)8);
            UtilEntity.dropItemStackInWorld(worldObj, pos, new ItemStack(Items.field_151116_aA, rand));
        }
        if (this.bonusPork && entity instanceof EntityPig) {
            int rand = MathHelper.func_76136_a((Random)worldObj.field_73012_v, (int)1, (int)8);
            UtilEntity.dropItemStackInWorld(worldObj, pos, new ItemStack(Items.field_151147_al, rand));
        }
        if (this.bonusGolemIron && entity instanceof EntityIronGolem) {
            int rand = MathHelper.func_76136_a((Random)worldObj.field_73012_v, (int)1, (int)18);
            UtilEntity.dropItemStackInWorld(worldObj, pos, new ItemStack(Items.field_151042_j, rand));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.mobs";
        sheepShearBuffed = config.getBoolean("Sheep Shear Bonus", category, true, "Shearing sheep randomly adds bonus wool");
        this.zombieVillagerEmeralds = config.getBoolean("Zombie Villager Emerald", category, true, "Zombie villagers have a " + this.chanceZombieVillagerEmerald + "% chance to drop an emerald");
        this.extraLeather = config.getBoolean("Leather Bonus", category, true, "Leather drops from cows randomly increased");
        this.bonusPork = config.getBoolean("Pork Bonus", category, true, "Pig drops randomly increased");
        this.bonusGolemIron = config.getBoolean("Iron Bonus", category, true, "Iron Golem drops randomly increased");
    }
}

