/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventSaplingBlockGrowth
implements IHasConfig {
    private static final int sapling_oak = 0;
    private static final int sapling_spruce = 1;
    private static final int sapling_birch = 2;
    private static final int sapling_jungle = 3;
    private static final int sapling_acacia = 4;
    private static final int sapling_darkoak = 5;
    private static List<Integer> acaciaBiomes;
    private static List<Integer> spruceBiomes;
    private static List<Integer> oakBiomes;
    private static List<Integer> birchBiomes;
    private static List<Integer> darkoakBiomes;
    private static List<Integer> jungleBiomes;
    private boolean enabled;

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        BlockPos pos;
        if (!this.enabled) {
            return;
        }
        World world = event.getWorld();
        Block b = world.func_180495_p(pos = event.getPos()).func_177230_c();
        if (b != Blocks.field_150345_g) {
            return;
        }
        boolean treeAllowedToGrow = false;
        int meta = Blocks.field_150345_g.func_176201_c(world.func_180495_p(pos));
        int biomeID = Biome.func_185362_a((Biome)world.func_180494_b(pos));
        int growth_data = 8;
        int tree_type = meta - growth_data;
        switch (tree_type) {
            case 4: {
                treeAllowedToGrow = acaciaBiomes.contains(biomeID);
                break;
            }
            case 1: {
                treeAllowedToGrow = spruceBiomes.contains(biomeID);
                break;
            }
            case 0: {
                treeAllowedToGrow = oakBiomes.contains(biomeID);
                break;
            }
            case 2: {
                treeAllowedToGrow = birchBiomes.contains(biomeID);
                break;
            }
            case 5: {
                treeAllowedToGrow = darkoakBiomes.contains(biomeID);
                break;
            }
            case 3: {
                treeAllowedToGrow = jungleBiomes.contains(biomeID);
            }
        }
        if (!treeAllowedToGrow) {
            event.setResult(Event.Result.DENY);
            world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
            UtilEntity.dropItemStackInWorld(world, pos, new ItemStack(Blocks.field_150345_g, 1, tree_type));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.blocks";
        this.enabled = config.getBoolean("Sapling Home Biomes", category, true, "Saplings are only allowed to grow into trees in their home biome, otherwise they turn to dead bushes.  (Biome ids listed in config file)");
        category = "modpacks.SaplingGrowthDetail";
        config.addCustomCategoryComment(category, "Tweak the 'Sapling Home Biomes' feature: A list of biome IDs that each sapling is allowed to grow in.  Useful for modpacks that add extra biomes.  ");
        String oakCSV = config.get(category, "oak", "4, 18, 132, 39, 166, 167, 21, 23, 151, 149, 22, 6, 134, 3, 20, 34, 12, 29, 157").getString();
        oakBiomes = EventSaplingBlockGrowth.csvToInt(oakCSV);
        String acaciaCSV = config.get(category, "acacia", "35, 36, 38, 163, 164").getString();
        acaciaBiomes = EventSaplingBlockGrowth.csvToInt(acaciaCSV);
        String spruceCSV = config.get(category, "spruce", "5, 19, 32, 160, 161, 33, 30, 31, 158, 3, 20, 34, 21, 12, 13").getString();
        spruceBiomes = EventSaplingBlockGrowth.csvToInt(spruceCSV);
        String birchCSV = config.get(category, "birch", "27, 28, 155, 156, 4, 18, 132, 29, 157").getString();
        birchBiomes = EventSaplingBlockGrowth.csvToInt(birchCSV);
        String darkCSV = config.get(category, "dark_oak", "29, 157").getString();
        darkoakBiomes = EventSaplingBlockGrowth.csvToInt(darkCSV);
        String jungleCSV = config.get(category, "jungle", "21, 23, 22, 149, 151").getString();
        jungleBiomes = EventSaplingBlockGrowth.csvToInt(jungleCSV);
    }

    private static List<Integer> csvToInt(String csv) {
        String[] list;
        ArrayList<Integer> bi = new ArrayList<Integer>();
        for (String s_id : list = csv.split(",")) {
            try {
                int biome = Integer.parseInt(s_id.trim());
                bi.add(biome);
            }
            catch (Exception e) {
                ModMain.logger.warn("Invalid biome id from config file, must be integer: " + s_id);
            }
        }
        return bi;
    }
}

