/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSearchWorld;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventSpawnChunks {
    static final int SPAWN_RADIUS = 128;

    public static int blockToChunk(int blockVal) {
        return blockVal >> 4;
    }

    public static int chunkToBlock(int chunkVal) {
        return chunkVal << 4;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addSpawnInfo(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        BlockPos spawn = player.field_70170_p.func_175694_M();
        BlockPos here = player.func_180425_c();
        Chunk chunkHere = player.field_70170_p.func_175726_f(here);
        int xCenterOfChunk = EventSpawnChunks.chunkToBlock(chunkHere.field_76635_g) + 8;
        int zCenterOfChunk = EventSpawnChunks.chunkToBlock(chunkHere.field_76647_h) + 8;
        int xFromSpawn = Math.abs(xCenterOfChunk - spawn.func_177958_n());
        int zFromSpawn = Math.abs(zCenterOfChunk - spawn.func_177952_p());
        DecimalFormat df = new DecimalFormat("0.0");
        double dist = UtilSearchWorld.distanceBetweenHorizontal(here, spawn);
        event.getLeft().add(UtilChat.lang("debug.spawn.distance") + df.format(dist));
        if (xFromSpawn < 128 && zFromSpawn < 128) {
            event.getLeft().add(TextFormatting.GREEN + UtilChat.lang("debug.spawn.chunks"));
        }
    }
}

