/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.gui.wand.InventoryWand;
import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.net.PacketSpellShiftLeft;
import com.lothrazar.cyclicmagic.net.PacketSpellShiftRight;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import com.lothrazar.cyclicmagic.util.UtilTextureRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventSpells {
    public static SpellHud spellHud;

    public EventSpells() {
        spellHud = new SpellHud();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.func_70093_af() || event.getDwheel() == 0) {
            return;
        }
        ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld((EntityPlayer)player);
        if (wand == null) {
            return;
        }
        if (SpellRegistry.getSpellbook(wand) == null || SpellRegistry.getSpellbook(wand).size() <= 1) {
            return;
        }
        if (event.getDwheel() < 0) {
            ModMain.network.sendToServer((IMessage)new PacketSpellShiftRight());
            event.setCanceled(true);
            UtilSound.playSound((EntityPlayer)player, player.func_180425_c(), SoundRegistry.bip);
        } else if (event.getDwheel() > 0) {
            ModMain.network.sendToServer((IMessage)new PacketSpellShiftLeft());
            event.setCanceled(true);
            UtilSound.playSound((EntityPlayer)player, player.func_180425_c(), SoundRegistry.bip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTextOverlay(RenderGameOverlayEvent.Text event) {
        ItemStack wand;
        CapabilityRegistry.IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (props.getTODO() != null && props.getTODO().length() > 0) {
            event.getRight().add(props.getTODO());
        }
        if ((wand = UtilSpellCaster.getPlayerWandIfHeld((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != null) {
            spellHud.drawSpellWheel(wand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        EntityPlayerSP effectivePlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldWand = UtilSpellCaster.getPlayerWandIfHeld((EntityPlayer)effectivePlayer);
        if (heldWand == null) {
            return;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        int itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
        ItemStack current = InventoryWand.getFromSlot(heldWand, itemSlot);
        if (current != null) {
            itemRender.func_180450_b(current, 13, 38);
        }
        RenderHelper.func_74518_a();
    }

    private class SpellHud {
        private static final int xoffset = 14;
        private static final int ymain = 6;
        private static final int spellSize = 16;
        private int xmain;

        private SpellHud() {
        }

        @SideOnly(value=Side.CLIENT)
        public void drawSpellWheel(ItemStack wand) {
            if (SpellRegistry.renderOnLeft) {
                this.xmain = 14;
            } else {
                ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
                this.xmain = res.func_78326_a() - 14;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ISpell spellCurrent = UtilSpellCaster.getPlayerCurrentISpell((EntityPlayer)player);
            if (SpellRegistry.getSpellbook(wand) == null || SpellRegistry.getSpellbook(wand).size() <= 1) {
                return;
            }
            this.drawCurrentSpell((EntityPlayer)player, spellCurrent);
            this.drawNextSpells((EntityPlayer)player, spellCurrent);
            this.drawPrevSpells((EntityPlayer)player, spellCurrent);
        }

        private void drawCurrentSpell(EntityPlayer player, ISpell spellCurrent) {
            UtilTextureRender.drawTextureSquare(spellCurrent.getIconDisplay(), this.xmain, 6, 16);
        }

        private void drawPrevSpells(EntityPlayer player, ISpell spellCurrent) {
            ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
            ISpell prev = SpellRegistry.prev(wand, spellCurrent);
            if (prev != null) {
                int x = this.xmain + 9;
                int y = 22;
                int dim = 8;
                UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x, y, dim);
                prev = SpellRegistry.prev(wand, prev);
                if (prev != null) {
                    UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 5, y += 14, dim -= 2);
                    prev = SpellRegistry.prev(wand, prev);
                    if (prev != null) {
                        UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 3, y += 10, dim -= 2);
                        prev = SpellRegistry.prev(wand, prev);
                        if (prev != null) {
                            UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 2, y += 10, --dim);
                        }
                    }
                }
            }
        }

        private void drawNextSpells(EntityPlayer player, ISpell spellCurrent) {
            ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
            ISpell next = SpellRegistry.next(wand, spellCurrent);
            if (next != null) {
                int x = this.xmain - 5;
                int y = 22;
                int dim = 8;
                UtilTextureRender.drawTextureSquare(next.getIconDisplay(), x, y, dim);
                ISpell next2 = SpellRegistry.next(wand, next);
                if (next2 != null) {
                    UtilTextureRender.drawTextureSquare(next2.getIconDisplay(), x -= 2, y += 14, dim -= 2);
                    ISpell next3 = SpellRegistry.next(wand, next2);
                    if (next3 != null) {
                        UtilTextureRender.drawTextureSquare(next3.getIconDisplay(), x -= 2, y += 10, dim -= 2);
                        ISpell next4 = SpellRegistry.next(wand, next3);
                        if (next4 != null) {
                            UtilTextureRender.drawTextureSquare(next4.getIconDisplay(), x -= 2, y += 10, --dim);
                        }
                    }
                }
            }
        }
    }
}

