/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event.core;

import com.google.common.io.Files;
import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.gui.player.ButtonTabToggleCrafting;
import com.lothrazar.cyclicmagic.gui.player.ButtonTabToggleInventory;
import com.lothrazar.cyclicmagic.gui.player.GuiPlayerExtended;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.util.UtilPlayerInventoryFilestorage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventExtendedInventory
implements IHasConfig {
    static HashSet<Integer> playerEntityIds = new HashSet();
    final String ext = "invo";
    final String extback = "backup";

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            playerEntityIds.add(event.player.func_145782_y());
        }
    }

    public static void syncItems(EntityPlayer player) {
        int size = 32;
        for (int a = 0; a < size; ++a) {
            UtilPlayerInventoryFilestorage.getPlayerInventory(player).syncSlotToClients(a);
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!playerEntityIds.isEmpty() && playerEntityIds.contains(player.func_145782_y())) {
                EventExtendedInventory.syncItems(player);
                playerEntityIds.remove(player.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        File fileNew;
        UtilPlayerInventoryFilestorage.clearPlayerInventory(event.getEntityPlayer());
        File playerFile = this.getPlayerFile("invo", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString());
        if (!playerFile.exists() && (fileNew = event.getPlayerFile("invo")).exists()) {
            try {
                Files.copy((File)fileNew, (File)playerFile);
                ModMain.logger.info("Using and converting UUID Baubles savefile for " + event.getEntityPlayer().getDisplayNameString());
                fileNew.delete();
                File fb = event.getPlayerFile("backup");
                if (fb.exists()) {
                    fb.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        UtilPlayerInventoryFilestorage.loadPlayerInventory(event.getEntityPlayer(), playerFile, this.getPlayerFile("backup", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString()));
        playerEntityIds.add(event.getEntityPlayer().func_145782_y());
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        return new File(playerDirectory, "_" + playername + "." + suffix);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        UtilPlayerInventoryFilestorage.savePlayerBaubles(event.getEntityPlayer(), this.getPlayerFile("invo", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString()), this.getPlayerFile("backup", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString()));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiInventory || gui instanceof GuiPlayerExtended || gui instanceof GuiCrafting || gui instanceof GuiScreenHorseInventory) {
            int xSize = 176;
            int ySize = 166;
            int guiLeft = (gui.field_146294_l - xSize) / 2;
            int guiTop = (gui.field_146295_m - ySize) / 2;
            int x = 30 + guiLeft;
            int y = guiTop + 2;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            CapabilityRegistry.IPlayerExtendedProperties data = CapabilityRegistry.getPlayerProperties((EntityPlayer)player);
            if (data.hasInventoryExtended()) {
                event.getButtonList().add(new ButtonTabToggleInventory(gui, x, y));
            }
            if (data.hasInventoryCrafting()) {
                event.getButtonList().add(new ButtonTabToggleCrafting(gui, x - 12, y));
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
    }
}

