/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.wand;

import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class InventoryWand
implements IInventory {
    public static final int INV_SIZE = 18;
    private ItemStack[] inventory = new ItemStack[18];
    private final ItemStack internalWand;
    private EntityPlayer thePlayer;

    public EntityPlayer getPlayer() {
        return this.thePlayer;
    }

    public InventoryWand(EntityPlayer player, ItemStack wand) {
        this.internalWand = wand;
        this.inventory = InventoryWand.readFromNBT(wand);
        this.thePlayer = player;
    }

    public String func_70005_c_() {
        return "Wand Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return 18;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
        for (i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
            if (this.thePlayer.field_71071_by.func_70301_a(i) == null || this.thePlayer.field_71071_by.func_70301_a((int)i).field_77994_a != 0) continue;
            this.thePlayer.field_71071_by.func_70299_a(i, null);
        }
        InventoryWand.writeToNBT(this.internalWand, this.inventory);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return UtilSpellCaster.getPlayerWandIfHeld(player) != null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemCyclicWand) && Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    public static ItemStack[] readFromNBT(ItemStack stack) {
        ItemStack[] inv = new ItemStack[18];
        if (stack == null || !(stack.func_77973_b() instanceof ItemCyclicWand)) {
            return inv;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = stack.func_77978_p().func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 18) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        return inv;
    }

    public static void writeToNBT(ItemStack wandStack, ItemStack[] theInventory) {
        NBTTagCompound tagcompound = wandStack.func_77978_p();
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < theInventory.length; ++i) {
            ItemStack stack = theInventory[i];
            if (stack != null && stack.field_77994_a == 0) {
                stack = null;
            }
            if (stack == null) continue;
            NBTTagCompound itemTags = new NBTTagCompound();
            itemTags.func_74768_a("Slot", i);
            stack.func_77955_b(itemTags);
            items.func_74742_a((NBTBase)itemTags);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public static void decrementSlot(ItemStack wand, int itemSlot) {
        ItemStack[] invv = InventoryWand.readFromNBT(wand);
        --invv[itemSlot].field_77994_a;
        if (invv[itemSlot].field_77994_a == 0) {
            invv[itemSlot] = null;
        }
        InventoryWand.writeToNBT(wand, invv);
    }

    public static ItemStack getFromSlot(ItemStack wand, int i) {
        if (i < 0 || i >= 18) {
            return null;
        }
        return InventoryWand.readFromNBT(wand)[i];
    }

    public static IBlockState getToPlaceFromSlot(ItemStack wand, int i) {
        ItemStack toPlace = InventoryWand.getFromSlot(wand, i);
        if (toPlace != null && toPlace.func_77973_b() != null && Block.func_149634_a((Item)toPlace.func_77973_b()) != null) {
            return Block.func_149634_a((Item)toPlace.func_77973_b()).func_176203_a(toPlace.func_77960_j());
        }
        return null;
    }

    public static int calculateSlotCurrent(ItemStack wand) {
        int itemSlot = ItemCyclicWand.BuildType.getSlot(wand);
        int buildType = ItemCyclicWand.BuildType.get(wand);
        ItemStack[] inv = InventoryWand.readFromNBT(wand);
        ArrayList<Integer> slotNonEmpty = new ArrayList<Integer>();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() == null || Block.func_149634_a((Item)inv[i].func_77973_b()) == null) continue;
            slotNonEmpty.add(i);
        }
        boolean doRotate = false;
        if (buildType == ItemCyclicWand.BuildType.FIRST.ordinal()) {
            if (inv[itemSlot] == null) {
                doRotate = true;
            }
        } else if (buildType == ItemCyclicWand.BuildType.ROTATE.ordinal()) {
            doRotate = true;
        } else if (buildType == ItemCyclicWand.BuildType.RANDOM.ordinal()) {
            Random rand = new Random();
            itemSlot = (Integer)slotNonEmpty.get(rand.nextInt(slotNonEmpty.size()));
        }
        if (doRotate) {
            int trySlot = itemSlot + 1;
            for (int i = 0; i < slotNonEmpty.size() + 1; ++i) {
                if (trySlot >= slotNonEmpty.size()) {
                    trySlot = 0;
                }
                if (inv[trySlot] == null) continue;
                itemSlot = trySlot;
                break;
            }
        }
        return itemSlot;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        int slot = ItemCyclicWand.BuildType.getSlot(this.internalWand);
        if (InventoryWand.getFromSlot(this.internalWand, slot) == null || InventoryWand.getToPlaceFromSlot(this.internalWand, slot) == null) {
            ItemCyclicWand.BuildType.setNextSlot(this.internalWand);
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

