/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemChestSack
extends BaseItem
implements IHasConfig {
    public static final String name = "chest_sack";
    public static final String KEY_NBT = "itemtags";
    public static final String KEY_BLOCK = "block";

    public ItemChestSack() {
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos offset = pos.func_177972_a(side);
        if (!worldIn.func_175623_d(offset)) {
            return EnumActionResult.FAIL;
        }
        if (this.createAndFillChest(playerIn, stack, offset)) {
            playerIn.func_184611_a(hand, null);
            UtilSound.playSound(playerIn, pos, SoundRegistry.thunk);
            UtilEntity.dropItemStackInWorld(worldIn, playerIn.func_180425_c(), ItemRegistry.itemMap.get("chest_sack_empty"));
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean createAndFillChest(EntityPlayer entityPlayer, ItemStack heldChestSack, BlockPos pos) {
        Block block = Block.func_149729_e((int)heldChestSack.func_77978_p().func_74762_e(KEY_BLOCK));
        if (Block.func_149729_e((int)heldChestSack.func_77978_p().func_74762_e(KEY_BLOCK)) == null) {
            return false;
        }
        entityPlayer.field_70170_p.func_175656_a(pos, block.func_176223_P());
        IInventory invo = (IInventory)entityPlayer.field_70170_p.func_175625_s(pos);
        if (invo == null) {
            return false;
        }
        UtilNBT.writeTagsToInventory(invo, heldChestSack.func_77978_p(), KEY_NBT);
        heldChestSack.field_77994_a = 0;
        heldChestSack.func_77982_d(null);
        return true;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advanced) {
        int count = UtilNBT.countItemsFromNBT(itemStack.func_77978_p(), KEY_NBT);
        list.add("" + count);
    }

    @Override
    public void syncConfig(Configuration config) {
    }
}

