/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.gui.wand.InventoryWand;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.spell.BaseSpellRange;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemCyclicWand
extends Item
implements IHasRecipe,
IHasConfig {
    private static final String NBT_SPELLCURRENT = "spell_id";
    private List<ISpell> spellbook;

    public ItemCyclicWand() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77642_a(this);
    }

    public void setSpells(List<ISpell> spells) {
        this.spellbook = spells;
    }

    public List<ISpell> getSpells() {
        return this.spellbook;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!slotChanged) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        Spells.setSpellCurrent(stack, SpellRegistry.getSpellbook(stack).get(0).getID());
        super.func_77622_d(stack, worldIn, playerIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ISpell spell = SpellRegistry.getSpellFromID(Spells.getSpellIDCurrent(stack));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.GREEN + spell.getName() + " " + "[" + UtilChat.lang(BuildType.getName(stack)) + "] ");
            tooltip.add(TextFormatting.DARK_GRAY + UtilChat.lang("item.cyclic_wand.shifting"));
        } else {
            tooltip.add(TextFormatting.DARK_GRAY + UtilChat.lang("item.shift"));
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.UNCOMMON;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean success = UtilSpellCaster.tryCastCurrent(worldIn, playerIn, pos, side, stack, hand);
        return success ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean success = UtilSpellCaster.tryCastCurrent(worldIn, playerIn, null, null, itemStackIn, hand);
        return success ? new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn) : new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.items";
        SpellRegistry.renderOnLeft = config.getBoolean("Build Scepter HUD", category, true, "True for top left of the screen, false for top right");
        category = "modpacks";
        BaseSpellRange.maxRange = config.getInt("Build Scepter Max Range", category, 64, 8, 128, "Maximum range for all spells");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"sds", " o ", "gog", Character.valueOf('d'), new ItemStack(Blocks.field_150484_ah), Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('s'), Items.field_151156_bN});
    }

    public static enum BuildType {
        FIRST,
        ROTATE,
        RANDOM;

        private static final String NBT = "build";
        private static final String NBT_SLOT = "buildslot";
        private static final String NBT_SIZE = "buildsize";

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "button.build." + BuildType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "button.build." + FIRST.toString().toLowerCase();
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > RANDOM.ordinal()) {
                type = FIRST.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
            int slot = BuildType.getSlot(wand);
            if (InventoryWand.getFromSlot(wand, slot) == null || InventoryWand.getToPlaceFromSlot(wand, slot) == null) {
                BuildType.setNextSlot(wand);
            }
        }

        public static int getBuildSize(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int s = tags.func_74762_e(NBT_SIZE);
            return s;
        }

        public static void setBuildSize(ItemStack wand, int size) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            tags.func_74768_a(NBT_SIZE, size);
            wand.func_77982_d(tags);
        }

        public static int getSlot(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            if (!tags.func_74764_b(NBT_SLOT)) {
                tags.func_74768_a(NBT_SLOT, 0);
                return 0;
            }
            return tags.func_74762_e(NBT_SLOT);
        }

        public static void setNextSlot(ItemStack wand) {
            int next;
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int prev = BuildType.getSlot(wand);
            if (prev != (next = InventoryWand.calculateSlotCurrent(wand))) {
                tags.func_74768_a(NBT_SLOT, next);
            }
        }
    }

    public static class Spells {
        public static int getSpellIDCurrent(ItemStack stack) {
            if (!UtilNBT.getItemStackNBT(stack).func_74764_b(ItemCyclicWand.NBT_SPELLCURRENT)) {
                return SpellRegistry.getSpellbook(stack).get(0).getID();
            }
            int c = UtilNBT.getItemStackNBT(stack).func_74762_e(ItemCyclicWand.NBT_SPELLCURRENT);
            return c;
        }

        public static ISpell getSpellCurrent(ItemStack stack) {
            int idCurrent = Spells.getSpellIDCurrent(stack);
            ISpell s = SpellRegistry.getSpellFromID(idCurrent);
            return s;
        }

        public static void setSpellCurrent(ItemStack stack, int spell_id) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(stack);
            tags.func_74768_a(ItemCyclicWand.NBT_SPELLCURRENT, spell_id);
            stack.func_77982_d(tags);
        }
    }
}

