/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFoodCorruptedChorus
extends ItemFood
implements IHasRecipe,
IHasConfig {
    private static final int numFood = 2;
    private static final String tooltip = "Lets you phase through walls for a few seconds";
    private static final String KEY_BOOLEAN = "ghost_on";
    private static final String KEY_TIMER = "ghost_timer";
    private static final String KEY_EATLOC = "ghost_location";
    private static final String KEY_EATDIM = "ghost_dim";
    public static int GHOST_SECONDS = 5;
    public static int POTION_SECONDS = 20;

    public ItemFoodCorruptedChorus() {
        super(2, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        ItemFoodCorruptedChorus.setPlayerGhostMode(player, world);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltips, boolean advanced) {
        tooltips.add(tooltip);
    }

    @Override
    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 3), (Object[])new Object[]{"lal", "lal", "lal", Character.valueOf('l'), Items.field_151071_bq, Character.valueOf('a'), Items.field_185161_cS});
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "modpacks";
        GHOST_SECONDS = config.getInt("CorruptedChorusSeconds", category, 5, 1, 60, "How long you can noclip after eating corrupted chorus");
        POTION_SECONDS = config.getInt("CorruptedChorusPotions", category, 10, 1, 60, "How long the negative potion effects last after a corrupted chorus teleports you");
    }

    public static void setPlayerGhostMode(EntityPlayer player, World par2World) {
        if (!par2World.field_72995_K) {
            player.func_71033_a(WorldSettings.GameType.SPECTATOR);
            UtilNBT.incrementPlayerIntegerNBT(player, KEY_TIMER, GHOST_SECONDS * 20);
            player.getEntityData().func_74757_a(KEY_BOOLEAN, true);
            player.getEntityData().func_74778_a(KEY_EATLOC, UtilNBT.posToStringCSV(player.func_180425_c()));
            player.getEntityData().func_74768_a(KEY_EATDIM, player.field_71093_bK);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        World world = player.field_70170_p;
        if (player.getEntityData().func_74767_n(KEY_BOOLEAN)) {
            int playerGhost = player.getEntityData().func_74762_e(KEY_TIMER);
            if (playerGhost > 0) {
                if (playerGhost % 20 == 0) {
                    int secs = playerGhost / 20;
                    UtilChat.addChatMessage(player, "" + secs);
                }
                UtilNBT.incrementPlayerIntegerNBT(player, KEY_TIMER, -1);
            } else {
                player.getEntityData().func_74757_a(KEY_BOOLEAN, false);
                if (player.getEntityData().func_74762_e(KEY_EATDIM) != player.field_71093_bK) {
                    player.func_71033_a(WorldSettings.GameType.SURVIVAL);
                    player.func_70097_a(DamageSource.field_76376_m, 50.0f);
                } else {
                    String posCSV = player.getEntityData().func_74779_i(KEY_EATLOC);
                    String[] p = posCSV.split(",");
                    BlockPos currentPos = player.func_180425_c();
                    BlockPos sourcePos = new BlockPos(Double.parseDouble(p[0]), Double.parseDouble(p[1]), Double.parseDouble(p[2]));
                    if (world.func_175623_d(currentPos) && world.func_175623_d(currentPos.func_177984_a())) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 20 * POTION_SECONDS));
                        player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 * POTION_SECONDS));
                    } else {
                        UtilEntity.teleportWallSafe((EntityLivingBase)player, world, sourcePos);
                    }
                    player.field_70143_R = 0.0f;
                    player.func_71033_a(WorldSettings.GameType.SURVIVAL);
                }
            }
        }
    }
}

