/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemFoodHeart
extends ItemFood
implements IHasRecipe,
IHasConfig {
    private static final int numFood = 2;
    private static final int numHearts = 1;
    private static int maxHearts = 20;

    public ItemFoodHeart() {
        super(2, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        CapabilityRegistry.IPlayerExtendedProperties prop = CapabilityRegistry.getPlayerProperties(player);
        if (UtilEntity.getMaxHealth((EntityLivingBase)player) / 2.0 >= (double)maxHearts) {
            UtilSound.playSound(player, SoundRegistry.buzzp);
            UtilEntity.dropItemStackInWorld(world, player.func_180425_c(), (Item)this);
            return;
        }
        int newVal = UtilEntity.incrementMaxHealth((EntityLivingBase)player, 2);
        prop.setMaxHealth(newVal);
        UtilSound.playSound(player, SoundRegistry.fill);
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{Items.field_185164_cV, Items.field_179558_bo, Items.field_151158_bO, Items.field_151045_i, Items.field_151105_aU, Blocks.field_150475_bE, new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), Items.field_151153_ao, Items.field_151170_bI});
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        CapabilityRegistry.IPlayerExtendedProperties src = CapabilityRegistry.getPlayerProperties(event.getOriginal());
        CapabilityRegistry.IPlayerExtendedProperties dest = CapabilityRegistry.getPlayerProperties(event.getEntityPlayer());
        dest.setDataFromNBT(src.getDataAsNBT());
        if (event.isWasDeath() && src.getMaxHealth() > 0) {
            UtilEntity.setMaxHealth((EntityLivingBase)event.getEntityPlayer(), src.getMaxHealth());
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        maxHearts = config.getInt("HeartContainerMax", "modpacks", 20, 10, 100, "Maximum number of heart containers you can get by eating heart containers.  Does not limit the /sethearts command");
    }
}

