/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFoodHorse
extends BaseItem
implements IHasRecipe {
    public static int HEARTS_MAX;
    public static int SPEED_MAX;
    public static int JUMP_MAX;
    private static double JUMP_SCALE;
    private static double SPEED_SCALE;
    private ItemStack recipeItem;

    public ItemFoodHorse(ItemStack rec) {
        this.recipeItem = rec;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        Item carrot = stack.func_77973_b();
        tooltip.add(I18n.func_135052_a((String)(carrot.func_77667_c(stack) + ".effect"), (Object[])new Object[0]));
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{Items.field_151172_bF, this.recipeItem});
    }

    public static void onHorseInteract(EntityHorse horse, EntityPlayer player, ItemStack held) {
        double speed;
        double newSpeed;
        boolean success = false;
        if (held.func_77973_b() == ItemRegistry.itemMap.get("emeraldCarrot")) {
            switch (horse.func_184781_cZ()) {
                case HORSE: {
                    horse.func_184778_a(HorseType.ZOMBIE);
                    success = true;
                    break;
                }
                case ZOMBIE: {
                    horse.func_184778_a(HorseType.SKELETON);
                    success = true;
                    break;
                }
                case SKELETON: {
                    horse.func_184778_a(HorseType.HORSE);
                    success = true;
                    break;
                }
                case DONKEY: {
                    break;
                }
                case MULE: {
                    break;
                }
            }
        } else if (held.func_77973_b() == ItemRegistry.itemMap.get("lapisCarrot")) {
            int var = horse.func_110202_bQ();
            int var_reduced = 0;
            int var_new = 0;
            while (var - 256 > 0) {
                var_reduced += 256;
                var -= 256;
            }
            switch (var) {
                case 4: {
                    var_new = 3;
                    break;
                }
                case 3: {
                    var_new = 6;
                    break;
                }
                case 6: {
                    var_new = 2;
                    break;
                }
                case 2: {
                    var_new = 1;
                    break;
                }
                case 1: {
                    var_new = 5;
                    break;
                }
                case 5: {
                    var_new = 0;
                    break;
                }
                case 0: {
                    var_new = 4;
                }
            }
            horse.func_110235_q(var_new += var_reduced);
            success = true;
        } else if (held.func_77973_b() == ItemRegistry.itemMap.get("diamondCarrot")) {
            float mh = (float)horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
            if (mh < (float)(2 * HEARTS_MAX)) {
                horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(mh + 2.0f));
                success = true;
            }
        } else if (held.func_77973_b() == ItemRegistry.itemMap.get("horse_upgrade_jump")) {
            double jump;
            double newjump;
            if (ReflectionRegistry.horseJumpStrength != null && UtilEntity.getJumpTranslated(newjump = (jump = horse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111126_e()) * JUMP_SCALE) < (double)JUMP_MAX) {
                horse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111128_a(newjump);
                success = true;
            }
        } else if (held.func_77973_b() == ItemRegistry.itemMap.get("horse_upgrade_speed") && UtilEntity.getSpeedTranslated(newSpeed = (speed = horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()) * SPEED_SCALE) < (double)SPEED_MAX) {
            horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(newSpeed);
            success = true;
        }
        if (success) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            double x = horse.func_180425_c().func_177958_n();
            double y = horse.func_180425_c().func_177956_o();
            double z = horse.func_180425_c().func_177952_p();
            for (int countparticles = 0; countparticles <= 10; ++countparticles) {
                horse.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x + (horse.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.8, y + horse.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.1, z + (horse.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0, new int[0]);
            }
            UtilSound.playSound(player, horse.func_180425_c(), SoundEvents.field_187711_cp, SoundCategory.NEUTRAL);
            horse.func_110227_p(true);
        }
    }

    public static void syncConfig(Configuration config) {
        String category = "modpacks";
        HEARTS_MAX = config.getInt("HorseFood Max Hearts", category, 20, 1, 100, "Maximum number of upgraded hearts");
        JUMP_MAX = config.getInt("HorseFood Max Jump", category, 6, 1, 20, "Maximum value of jump.  Naturally spawned/bred horses seem to max out at 5.5");
        SPEED_MAX = config.getInt("HorseFood Max Speed", category, 50, 1, 99, "Maximum value of speed (this is NOT blocks/per second or anything like that)");
    }

    static {
        JUMP_SCALE = 1.02;
        SPEED_SCALE = 1.05;
    }

    public static class Horse {
        public static final int variant_white = 0;
        public static final int variant_creamy = 1;
        public static final int variant_chestnut = 2;
        public static final int variant_brown = 3;
        public static final int variant_black = 4;
        public static final int variant_gray = 5;
        public static final int variant_brown_dark = 6;
        public static final int type_standard = 0;
        public static final int type_donkey = 1;
        public static final int type_mule = 2;
        public static final int type_zombie = 3;
        public static final int type_skeleton = 4;
    }
}

