/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseTool;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolPush
extends BaseTool
implements IHasRecipe {
    private static final int durability = 5000;

    public ItemToolPush() {
        super(5000);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ItemStack held = entityPlayer.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(entityPlayer, SoundRegistry.dcoin);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                ActionType.toggle(held);
                UtilChat.addChatMessage(entityPlayer, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos resultPosition = null;
        boolean success = false;
        switch (ActionType.values()[ActionType.get(stack)]) {
            case PULL: {
                resultPosition = UtilPlaceBlocks.pullBlock(worldObj, player, pos, side);
                success = resultPosition != null;
                break;
            }
            case PUSH: {
                resultPosition = UtilPlaceBlocks.pushBlock(worldObj, player, pos, side);
                success = resultPosition != null;
                break;
            }
            case ROTATE: {
                success = UtilPlaceBlocks.rotateBlockValidState(pos, worldObj, side, player);
                resultPosition = pos;
                break;
            }
        }
        if (success) {
            this.onUse(stack, player, worldObj, hand);
        }
        return super.func_180614_a(stack, player, worldObj, resultPosition, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" gp", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('p'), Blocks.field_150320_F});
    }

    public static enum ActionType {
        PUSH,
        PULL,
        ROTATE;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "tool.action." + ActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "tool.action." + PUSH.toString().toLowerCase();
            }
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > ROTATE.ordinal()) {
                type = PUSH.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }
    }
}

